/*
 * Copyright (C) 2013 Tommi Maekitalo
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

#include "gtest/gtest.h"
#include <string>

namespace kiwix {
bool _parseUrl(const std::string& url, char* ns, std::string& title);
};

using namespace kiwix;

namespace
{
TEST(ParseUrlTest, invalid)
{
  char ns;
  std::string title;

  ASSERT_FALSE(_parseUrl("", &ns, title));
  ASSERT_FALSE(_parseUrl("A", &ns, title));
  ASSERT_FALSE(_parseUrl("/", &ns, title));
  ASSERT_FALSE(_parseUrl("//", &ns, title));
  ASSERT_FALSE(_parseUrl("/A", &ns, title));
  ASSERT_FALSE(_parseUrl("/A/", &ns, title));
  ASSERT_FALSE(_parseUrl("/AB", &ns, title));
  ASSERT_FALSE(_parseUrl("//A/title", &ns, title));
}

TEST(ParseUrlTest, valid)
{
  char ns;
  std::string title;

  ASSERT_TRUE(_parseUrl("A/title", &ns, title));
  ASSERT_EQ(ns, 'A');
  ASSERT_EQ(title, "title");

  ASSERT_TRUE(_parseUrl("/A/title", &ns, title));
  ASSERT_EQ(ns, 'A');
  ASSERT_EQ(title, "title");

  ASSERT_TRUE(_parseUrl("A//title", &ns, title));
  ASSERT_EQ(ns, 'A');
  ASSERT_EQ(title, "/title");

  ASSERT_TRUE(_parseUrl("/A//title", &ns, title));
  ASSERT_EQ(ns, 'A');
  ASSERT_EQ(title, "/title");
}
};
