/*****************************************************************************
 *	Hoard: A Fast, Scalable, and Memory-Efficient Allocator for 
 *	Shared-Memory Multiprocessors.
 *
 *	Portions: Copyright (c) 1998-2001, The University of Texas at Austin.
 *
 *	Portions of this are free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Library General Public License
 *	as published by the Free Software Foundation, http://www.fsf.org.
 *
 *	These portions are distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Library General Public License for more details.
 ****************************************************************************/

//#include <stdlib.h>

#define HOARD_PREFIX(x) x
// #define HOARD_PREFIX(x) HOARD_PREFIX(x) lh_##x

#include "config.h"
//#include "dbmem.h"

#define _CRTIMP __declspec(dllexport)

#include "threadheap.h"
#define HEAPTYPE threadHeap

#include "ntwrapper.h"
#include "processheap.h"
#include "arch-specific.h"

int atexit(void (__cdecl *)(void));

#pragma warning(disable: 4074)	// initializers put in compiler reserved area
#pragma init_seg(compiler)

#pragma comment(linker, "/merge:.CRT=.data")

#pragma comment(linker, "/disallowlib:libc.lib")
#pragma comment(linker, "/disallowlib:libcd.lib")
#pragma comment(linker, "/disallowlib:libcmt.lib")
#pragma comment(linker, "/disallowlib:libcmtd.lib")
#pragma comment(linker, "/disallowlib:msvcrt.lib")
#pragma comment(linker, "/disallowlib:msvcrtd.lib")

inline static processHeap * getAllocator (void) {
//  static char buf[sizeof(processHeap)];
  //  static char * buf = (char *) hoardGetMemory (sizeof(processHeap));
  static processHeap theAllocator;
//  static processHeap * theAllocator = new (buf) processHeap;
  return &theAllocator;
}


/*---------------------------------------------------------------------------
*/

int atexit(void (__cdecl *)(void)) { return 0; }
_onexit_t __cdecl _onexit(_onexit_t fn) { return 0; }

/*---------------------------------------------------------------------------
**	these operators are here so libhoard.dll will allocate through itself
*/
void * operator new(size_t size) { return HOARD_PREFIX(malloc) (size); }
void * operator new[](size_t size) { return HOARD_PREFIX(malloc) (size); }
void operator delete(void * ptr) { HOARD_PREFIX(free) (ptr); }
void operator delete[](void * ptr) { HOARD_PREFIX(free) (ptr); }

extern "C" {

__declspec(dllexport) size_t HOARD_PREFIX(_msize)(void *memblock)
{
  return threadHeap::objectSize (memblock);
  //	processHeap * pHeap = getAllocator();
  //	return pHeap->getHeap(pHeap->getHeapIndex()).objectSize(memblock);
}

// #ifdef _DEBUG

__declspec(dllexport) void *  HOARD_PREFIX(debug_operator_new) (unsigned int cb, int, const char *, int)
{
	return HOARD_PREFIX(malloc)(cb);
}

__declspec(dllexport) void    HOARD_PREFIX(debug_operator_delete) (void * p, int, const char *, int)
{
	HOARD_PREFIX(free)(p);
}

__declspec(dllexport) void * HOARD_PREFIX(nh_malloc_dbg)(size_t sz, size_t, int, int, const char *, int) {
	return HOARD_PREFIX(malloc) (sz);
}


/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void HOARD_PREFIX(assert_failed)(const char *assertion, const char *fileName, int lineNumber)
		{ __asm int 3 }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void *HOARD_PREFIX(_calloc_dbg)(size_t num, size_t size, 
		int blockType, const char *filename, int linenumber)
		{ return HOARD_PREFIX(calloc)(num, size); }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) int HOARD_PREFIX(_CrtCheckMemory)(void) { return 1; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void HOARD_PREFIX(_CrtDoForAllClientObjects)(void(*pfn)(void*,void*), void *context) { }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) int HOARD_PREFIX(_CrtDumpMemoryLeaks)(void) { return 0; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) int HOARD_PREFIX(_CrtIsMemoryBlock)(const void *userData, unsigned int size, 
		long *requestNumber, char **filename, int *linenumber) { return 1; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) int HOARD_PREFIX(_CrtIsValidHeapPointer)(const void *userData) { return 1; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void HOARD_PREFIX(_CrtMemCheckpoint)(_CrtMemState *state) { }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) int HOARD_PREFIX(_CrtMemDifference)(_CrtMemState *stateDiff, 
		const _CrtMemState *oldState, const _CrtMemState *newState) 
		{ return 0; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void HOARD_PREFIX(_CrtMemDumpAllObjectsSince)(const _CrtMemState *state) { }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void HOARD_PREFIX(_CrtMemDumpStatistics)(const _CrtMemState *state) { }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) _CRT_ALLOC_HOOK HOARD_PREFIX(_CrtSetAllocHook)(_CRT_ALLOC_HOOK allocHook) { return 0; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) long HOARD_PREFIX(_CrtSetBreakAlloc)(long lBreakAlloc) { return 0; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) int HOARD_PREFIX(_CrtSetDbgFlag)(int newFlag) { return _CRTDBG_ALLOC_MEM_DF; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) _CRT_DUMP_CLIENT HOARD_PREFIX(_CrtSetDumpClient)(_CRT_DUMP_CLIENT dumpClient) { return 0; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void *HOARD_PREFIX(_malloc_dbg)(size_t size, int blockType, 
		const char *filename, int linenumber)
		{ return HOARD_PREFIX(malloc)(size); }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void *HOARD_PREFIX(_expand_dbg)(void *userData, size_t newSize, int blockType, 
		const char *filename, int linenumber) { return NULL; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void HOARD_PREFIX(_free_dbg)(void *userData, int blockType) { HOARD_PREFIX(free)(userData); }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) size_t HOARD_PREFIX(_msize_dbg)(void *memblock, int blockType) 
		{ return HOARD_PREFIX(_msize)(memblock); }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void * HOARD_PREFIX(_realloc_dbg)(void *userData, size_t newSize, 
		int blockType, const char *filename, int linenumber)
		{ return HOARD_PREFIX(realloc)(userData, newSize); }

// #endif	// ? _DEBUG

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void *HOARD_PREFIX(_expand)(void * mem, size_t sz) { return NULL; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) int HOARD_PREFIX(_heapchk)(void) { return _HEAPOK; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) int HOARD_PREFIX(_heapmin)(void) { return 0; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) int HOARD_PREFIX(_heapset)(unsigned int) { return _HEAPOK; }

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) int HOARD_PREFIX(_heapwalk)(_HEAPINFO *) { return _HEAPEND; }


/*---------------------------------------------------------------------------
*/
void *  HOARD_PREFIX(new_nothrow)(unsigned int sz,struct std::nothrow_t const &) {
	return HOARD_PREFIX(malloc)(sz);
}

/*---------------------------------------------------------------------------
*/

// From Doug Lea's malloc.

#define MALLOC_ZERO(charp, nbytes)                                            \
do {                                                                          \
  size_t* mzp = (size_t*)(charp);                           \
  unsigned long mctmp = (nbytes)/sizeof(size_t);                     \
  long mcn;                                                                   \
  if (mctmp < 8) mcn = 0; else { mcn = (mctmp-1)/8; mctmp %= 8; }             \
  switch (mctmp) {                                                            \
    case 0: for(;;) { *mzp++ = 0;                                             \
    case 7:           *mzp++ = 0;                                             \
    case 6:           *mzp++ = 0;                                             \
    case 5:           *mzp++ = 0;                                             \
    case 4:           *mzp++ = 0;                                             \
    case 3:           *mzp++ = 0;                                             \
    case 2:           *mzp++ = 0;                                             \
    case 1:           *mzp++ = 0; if(mcn <= 0) break; mcn--; }                \
  }                                                                           \
} while(0)

#define MALLOC_COPY(dest,src,nbytes)                                           \
do {                                                                          \
  size_t* mcsrc = (size_t*) src;                            \
  size_t* mcdst = (size_t*) dest;                           \
  unsigned long mctmp = (nbytes)/sizeof(size_t);                     \
  long mcn;                                                                   \
  if (mctmp < 8) mcn = 0; else { mcn = (mctmp-1)/8; mctmp %= 8; }             \
  switch (mctmp) {                                                            \
    case 0: for(;;) { *mcdst++ = *mcsrc++;                                    \
    case 7:           *mcdst++ = *mcsrc++;                                    \
    case 6:           *mcdst++ = *mcsrc++;                                    \
    case 5:           *mcdst++ = *mcsrc++;                                    \
    case 4:           *mcdst++ = *mcsrc++;                                    \
    case 3:           *mcdst++ = *mcsrc++;                                    \
    case 2:           *mcdst++ = *mcsrc++;                                    \
    case 1:           *mcdst++ = *mcsrc++; if(mcn <= 0) break; mcn--; }       \
  }                                                                           \
} while(0)


/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void * HOARD_PREFIX(calloc)(size_t nelem, size_t elsize)
{
	processHeap * pHeap = getAllocator();
	size_t sz = nelem * elsize;
	if (sz == 0) {
		sz = 1;
	}
	void * ptr = pHeap->getHeap(pHeap->getHeapIndex()).malloc(sz);
	MALLOC_ZERO(ptr, sz);
//	memset(ptr, 0, nelem * elsize);	// zero out the block (as per calloc)
	return ptr;
}

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void HOARD_PREFIX(free)(void * ptr)
{
  static processHeap * pHeap = getAllocator();
  pHeap->free(ptr);
}

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void * HOARD_PREFIX(malloc)(size_t sz)
{
  static processHeap * pHeap = getAllocator();
  void * addr = pHeap->getHeap(pHeap->getHeapIndex()).malloc(sz);
  return addr;
}

/*---------------------------------------------------------------------------
*/
__declspec(dllexport) void * HOARD_PREFIX(realloc)(void * ptr, size_t sz)
{
	if (!ptr)
		return HOARD_PREFIX(malloc)(sz);

	if (!sz)
	{
		HOARD_PREFIX(free)(ptr);
		return 0;
	}

	// If the existing object can hold the new size,
	// just return it.

	size_t objSize = threadHeap::objectSize (ptr);

	if (objSize >= sz) {
		return ptr;
	}


	// Allocate a new block of size sz.
	void * buf = HOARD_PREFIX(malloc)(sz);

	// Copy the contents of the original object
	// up to the size of the new block.
	size_t minSize = objSize < sz? objSize: sz;
	MALLOC_COPY(buf, ptr, minSize);
//	memcpy(buf, ptr, minSize);

	// Free the old block.
	HOARD_PREFIX(free)(ptr);

	// Return a pointer to the new one.
	return buf;
}

__declspec(dllexport) void * HOARD_PREFIX(_nh_malloc)(size_t sz, size_t, int, int, const char *, int) {
	return HOARD_PREFIX(malloc) (sz);
}

}
