package net.styx.flux.comm;

import java.net.*;
import java.io.*;
import java.util.*;

public class TTreeComm extends Thread {

    private Socket socket;

    private DataInputStream in;
    private DataOutputStream out;

    private int serial;
    private short transid;

    private boolean waitinginblock;
    private int waitinginblocksize;
    private int waitinginblockserial;
    private short waitinginblocktransid;
    private short waitinginblockflags;

    private boolean waitingoublock;
    private int waitingoutblocksize;
    private int waitingoutblockserial;
    private short waitingoutblocktransid;
    private short waitingoutblockflags;

    private TTree inttree;
    private TTree outttree;

    private DefaultListener defaultlistener;
    private TokenListenerList tokenlisteners;
    private TransactionList transactions;

    private Vector outqueue;


    public TTreeComm (java.net.InetAddress addr, int port, net.styx.flux.comm.DefaultListener defaultlistener) {

	serial = 0;
	transid = (short)0;
	outqueue = new Vector();

	tokenlisteners = new TokenListenerList();
	transactions = new TransactionList();
	this.defaultlistener = defaultlistener;

	try {
	    socket = new Socket(addr, port);

	    in = new DataInputStream( socket.getInputStream() );
	    out = new DataOutputStream( socket.getOutputStream() );
	    setDaemon(false);
	    
	    start();
	    
	} catch(Exception e) {
	    System.exit(0);
	}

    } //End of constructor

    public void run() {

	Transaction transaction = null;
	TokenListener tokenlistener = null;
	TransactionListener translistener = null;
	Vector listeners = null;
	int outqueuesize = 0;

	while(true) {
    
	    /* Input stage */
	    
	    try {
		
		if (outqueue != null) {
		    outqueuesize = outqueue.size();
		} else {
		    outqueuesize = 0;
		}

		if (!waitinginblock && in.available()<12 && outqueuesize == 0) {
		    sleep(50);
		    yield();
		} else if (!waitinginblock) {

		    waitinginblocksize    = in.readInt();
		    waitinginblockserial  = in.readInt();
		    waitinginblocktransid = in.readShort();
		    waitinginblockflags   = in.readShort();
		    
		    waitinginblock = true;
		}
		
		if(waitinginblock) {
		    inttree = new TTree( waitinginblocksize, waitinginblockserial, waitinginblocktransid, waitinginblockflags, in);
		    
		    if(waitinginblocktransid != 0) { //Look, this block wants to be part of something bigger!
			transaction = transactions.getTransaction(waitinginblocktransid);
			
			if (transaction != null) { //And yes, it is possible to rise above the rest.
			    translistener = transaction.getListener();
			    translistener.tTreeReceived(inttree, transaction);
			    
			} else { //Off to the default listener.
			    
			    defaultlistener.tTreeReceived(inttree, waitinginblocktransid, this);
			}
			
		    } else if ((inttree.getToken() != null) && (tokenlisteners.getListeners(inttree.getToken()) != null)) { //We have a registered TokenListener
			listeners = tokenlisteners.getListeners(inttree.getToken());
			
			for (int i = 0 ; i < listeners.size() ; i++ ) {
			    tokenlistener = (TokenListener)listeners.elementAt(i);
			    tokenlistener.tTreeReceived(inttree, inttree.getToken(), this );
			}
			
		    } else { // Default.
			defaultlistener.tTreeReceived(inttree, this);
		    }
		    
		    waitinginblock = false;
		    inttree = null;
		    translistener = null;
		    tokenlistener = null;
		    listeners = null;
		    transaction = null;
		    
		}
		
	    } catch (Exception e) {
		System.out.println("Input stage failed.");
		e.printStackTrace();
		System.exit(0);
	    }
	    
		    
	    /* Output stage */
	    
	    if (outqueue != null) {
		
		outqueuesize = outqueue.size();
		
		if(outqueuesize != 0) {
		    
		    try {
			while( outqueuesize > 0 ) {
			    QueuedTTree currentqttree = (QueuedTTree)outqueue.elementAt(0);
			    currentqttree.toBlock(out);
			    outqueue.removeElementAt(0);
			    outqueuesize = outqueue.size();
			    out.flush();
			}
		    } catch (Exception e) {
			System.out.println("Output stage failed.");
			e.printStackTrace();
			System.exit(0);
		    }
		}
	    }
	    
	}
    }
    
    public synchronized void queueOutgoingTTree(TTree ttree, short transaction) {
	outqueue.addElement(new QueuedTTree(ttree, (serial+1), transaction, (short)0));
	serial += 1;
    }

    public synchronized void queueOutgoingTTree(TTree ttree) {
	outqueue.addElement(new QueuedTTree(ttree, (serial+1), (short)0, (short)0));
	serial += 1;
    }

    public synchronized Transaction startTransaction (TTree ttree, TransactionListener listener) {
	Transaction trans = new Transaction(this, transid, listener);

	addTransaction(trans);
	queueOutgoingTTree(ttree, transid);
	return trans;
    }

    public synchronized Transaction startTransaction (TTree ttree, TransactionListener listener, short transid) {
	Transaction trans = new Transaction(this, transid, listener);

	addTransaction(trans);
	queueOutgoingTTree(ttree, transid);
	return trans;
    }

    public synchronized void addTransaction(Transaction trans) {
	transactions.addTransaction(trans, trans.getTransID());
    }

    public synchronized void removeTransaction(short transid) {
	transactions.delTransaction(transid);
    }

    public synchronized void removeTransaction(Transaction trans) {
	transactions.delTransaction(trans);
    }

    public synchronized void addListener(byte[] token, TokenListener listener) {
	tokenlisteners.addListener(listener, token);
    }

    public synchronized void removeListener(TokenListener listener) {
	tokenlisteners.removeListener(listener);
    }

    public synchronized void removeToken(byte[] token) {
	tokenlisteners.removeToken(token);
    }

    

    class QueuedTTree {
	TTree ttree;
	int serial;
	short transid;
	short flags;
	
	QueuedTTree (TTree ttree, int serial, short transid, short flags) {
	    this.ttree = ttree;
	    this.serial = serial;
	    this.transid = transid;
	    this.flags = flags;
	}
	
	public synchronized void toBlock(DataOutputStream out) {
	    int datasize = calculateTreeSize(ttree);
	    
	    try {
		out.writeInt(datasize);
		out.writeInt(serial);
		out.writeShort(transid);
		out.writeShort(flags);
		
		branchToStream(ttree, out);
		
	    } catch (Exception e) {
		e.printStackTrace();
		System.exit(0);
	    }
	    
	}

	public void branchToStream(TTree ttree, DataOutputStream out) {
	    
	    try {
		out.writeInt(ttree.getTokenLength());
		out.writeInt(ttree.getChildCount());
		if(ttree.getTokenLength() != 0) {
		    out.write(ttree.getToken(), 0, ttree.getTokenLength());
		}
		
	    } catch (Exception e) {
		System.out.println("IOException while writing the branch data in branchToStream." );
		e.printStackTrace();
		System.exit(0);
	    }
	    
	    if (ttree.getChildCount() != 0) {
		for(int i = 0 ; i < ttree.getChildCount() ; i++ ) {
		    branchToStream(ttree.getChildAt(i), out);
		}
		
	    }
	}

	public int calculateTreeSize(TTree ttree) {
	    int size = 8;
	    
	    size += ttree.getTokenLength();
	    
	    int childcount = ttree.getChildCount();
	    
	    if (childcount != 0) {
		for(int i = 0 ; i < ttree.getChildCount() ; i++ ) {
		    size += calculateTreeSize(ttree.getChildAt(i));
		}	    
	    }
	    
	    return size;
	    
	}


    } //End of QueuedTTree


    class TransactionList {
	private Hashtable transactions;

	TransactionList() {
	    transactions = new Hashtable();
	}

	public void addTransaction(Transaction trans, short transid) {
	    Short transidshort = new Short(transid);

	    transactions.put(transidshort, trans);
	}

	public Transaction getTransaction(short transid) {
	    Short transidshort = new Short(transid);

	    return ((Transaction)transactions.get(transidshort));
	}

	public void delTransaction(short transid) {
	    Short transidshort = new Short(transid);

	    transactions.remove(transidshort);
	}

	public void delTransaction(Transaction trans) {
	    Short transidshort = new Short(trans.getTransID());
	    
	    transactions.remove(transidshort);
	}

    } //End of TransactionList

    class TokenListenerList {
	
	private Hashtable tokenlisteners;
	private Hashtable registeredtokens;

	TokenListenerList () {
	    tokenlisteners = new Hashtable();
	    registeredtokens = new Hashtable();
	}
	

	public void addListener(TokenListener listener, byte[] token) {

	    String tokenstring = new String(token);

	    Vector tokens = (Vector)tokenlisteners.get(listener);

	    /* Add to the tokenlisteners */

	    if(tokens == null) {
		tokens = new Vector();
		tokens.addElement(tokenstring);
		tokenlisteners.put (listener, tokens);
	    } else {
		tokens.addElement(token);
	    }

	    Vector listeners = (Vector)registeredtokens.get(tokenstring);

	    /* Add to the registeredtokens */

	    if(listeners == null) {
		listeners = new Vector();
		listeners.addElement(listener);
		registeredtokens.put (tokenstring, listeners);
	    } else {
		listeners.addElement(listener);
	    }
	} //End of addListener


	public Vector getListeners(byte[] token) {
	    
	    String tokenstring = new String(token);

	    Vector listeners = (Vector)registeredtokens.get (tokenstring);

	    return (listeners);
	} //End of getListeners


	public void removeListener(TokenListener listener) {

	    Vector tokens = (Vector)tokenlisteners.get(listener);
	    int numberoftokens;

	    if(tokens != null) {

		/* Remove from the tokenlisteners */
		tokenlisteners.remove(listener);

		numberoftokens = tokens.size();

		/* Remove from the registeredtokens */
		for(int i=0 ; i < numberoftokens ; i++) {

		    System.out.println(tokens.elementAt(i));

		    Vector listeners = (Vector)registeredtokens.get(tokens.elementAt(i));

		    listeners.removeElement(listener);

		 			
		    /* Remove the entire token if it has no more listeners */
		    if (listeners.size() == 0) {
			registeredtokens.remove(tokens.elementAt(i));
		    }
		    
		}
	    }
	} //End of removeListener

	public void removeToken(byte[] token) {
	    String tokenstring = new String(token);

	    Vector listeners = (Vector)tokenlisteners.get(tokenstring);
	    int numberoflisteners;

	    if(listeners != null) {
		
		/* Remove from the registeredtokens */
		registeredtokens.remove(tokenstring);


		numberoflisteners = listeners.size();

		/* Remove from the tokenlisteners */
		for(int i=0; i < numberoflisteners ; i++) {
		    
		    Vector tokens = (Vector)tokenlisteners.get(listeners.elementAt(i));
		    
		    listeners.removeElement(tokenstring);

		    /* Remove the entire listener if it has no more tokens */
		    if (tokens.size() == 0) {
			tokenlisteners.remove(listeners.elementAt(i));
		    }
		}
	    }
	} //End of removeToken

    } //End of TokenListenerList


} // End of TTreeComm.
