/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.KeyValue;

public final class StaticBucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 255;
    private Node[] m_buckets;
    private Lock[] m_locks;

    private final int getHash(Object key) {
        if (key == null) {
            return 0;
        }
        int hash = key.hashCode();
        hash += ~(hash << 15);
        hash ^= hash >>> 10;
        hash += hash << 3;
        hash ^= hash >>> 6;
        hash += ~(hash << 11);
        hash ^= hash >>> 16;
        return (hash %= this.m_buckets.length) < 0 ? hash * -1 : hash;
    }

    public final Set keySet() {
        return new KeySet();
    }

    public final int size() {
        int cnt = 0;
        int i = 0;
        while (i < this.m_buckets.length) {
            cnt += this.m_locks[i].size;
            ++i;
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object put(Object key, Object value) {
        int hash = this.getHash(key);
        Lock lock = this.m_locks[hash];
        synchronized (lock) {
            Node n = this.m_buckets[hash];
            if (n == null) {
                n = new Node();
                n.key = key;
                n.value = value;
                this.m_buckets[hash] = n;
                ++this.m_locks[hash].size;
                return null;
            }
            Node next = n;
            while (next != null) {
                n = next;
                if (n.key == key || n.key != null && n.key.equals(key)) {
                    Object returnVal = n.value;
                    n.value = value;
                    return returnVal;
                }
                next = next.next;
            }
            Node newNode = new Node();
            newNode.key = key;
            newNode.value = value;
            n.next = newNode;
            ++this.m_locks[hash].size;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object get(Object key) {
        int hash = this.getHash(key);
        Lock lock = this.m_locks[hash];
        synchronized (lock) {
            Node n = this.m_buckets[hash];
            while (n != null) {
                if (n.key == key || n.key != null && n.key.equals(key)) {
                    return n.value;
                }
                n = n.next;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean containsKey(Object key) {
        int hash = this.getHash(key);
        Lock lock = this.m_locks[hash];
        synchronized (lock) {
            Node n = this.m_buckets[hash];
            while (n != null) {
                if (n.key == null || n.key != null && n.key.equals(key)) {
                    return true;
                }
                n = n.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final boolean containsValue(Object value) {
        int i = 0;
        while (i < this.m_buckets.length) {
            Lock lock = this.m_locks[i];
            // MONITORENTER : lock
            {
                Node n = this.m_buckets[i];
                while (n != null) {
                    if (n.value == value || n.value != null && n.value.equals(value)) {
                        // MONITOREXIT : lock
                        return true;
                    }
                    n = n.next;
                }
                // MONITOREXIT : lock
                ++i;
            }
        }
        return false;
    }

    public final Collection values() {
        return new Values();
    }

    public final Set entrySet() {
        return new EntrySet();
    }

    public final void putAll(Map other) {
        Iterator i = other.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.put(key, other.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object remove(Object key) {
        int hash = this.getHash(key);
        Lock lock = this.m_locks[hash];
        synchronized (lock) {
            Node n = this.m_buckets[hash];
            Node prev = null;
            while (n != null) {
                if (n.key == key || n.key != null && n.key.equals(key)) {
                    if (prev == null) {
                        this.m_buckets[hash] = n.next;
                    } else {
                        prev.next = n.next;
                    }
                    --this.m_locks[hash].size;
                    return n.value;
                }
                prev = n;
                n = n.next;
            }
            return null;
        }
    }

    public final boolean isEmpty() {
        boolean bl = false;
        if (this.size() == 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void clear() {
        int i = 0;
        while (i < this.m_buckets.length) {
            Lock lock = this.m_locks[i];
            Lock lock2 = lock;
            synchronized (lock2) {
                this.m_buckets[i] = null;
                lock.size = 0;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                ++i;
            }
        }
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        return this.entrySet().equals(other.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.m_buckets.length) {
            Lock lock = this.m_locks[i];
            // MONITORENTER : lock
            {
                Node n = this.m_buckets[i];
                while (n != null) {
                    hashCode += n.hashCode();
                    n = n.next;
                }
                // MONITOREXIT : lock
                ++i;
            }
        }
        return hashCode;
    }

    public final void atomic(Runnable r) {
        if (r == null) {
            throw new NullPointerException();
        }
        this.atomic(r, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void atomic(Runnable r, int bucket) {
        if (bucket >= this.m_buckets.length) {
            r.run();
            return;
        }
        Lock lock = this.m_locks[bucket];
        synchronized (lock) {
            this.atomic(r, bucket + 1);
            return;
        }
    }

    public StaticBucketMap() {
        this(255);
    }

    public StaticBucketMap(int numBuckets) {
        int size = Math.max(17, numBuckets);
        if (size % 2 == 0) {
            --size;
        }
        this.m_buckets = new Node[size];
        this.m_locks = new Lock[size];
        int i = 0;
        while (i < size) {
            this.m_locks[i] = new Lock();
            ++i;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class KeySet
    extends AbstractSet {
        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public boolean contains(Object o) {
            return StaticBucketMap.this.containsKey(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean remove(Object o) {
            int hash = StaticBucketMap.this.getHash(o);
            Lock lock = StaticBucketMap.this.m_locks[hash];
            synchronized (lock) {
                Node n = StaticBucketMap.this.m_buckets[hash];
                while (n != null) {
                    Object k = n.getKey();
                    if (k == o || k != null && k.equals(o)) {
                        StaticBucketMap.this.remove(k);
                        return true;
                    }
                    n = n.next;
                }
                return false;
            }
        }

        private KeySet() {
        }
    }

    private static final class Lock {
        public int size;

        private Lock() {
        }
    }

    private static final class Node
    implements Map.Entry,
    KeyValue {
        protected Object key;
        protected Object value;
        protected Node next;

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final int hashCode() {
            int n = 0;
            if (this.key != null) {
                n = this.key.hashCode();
            }
            int n2 = 0;
            if (this.value != null) {
                n2 = this.value.hashCode();
            }
            return n ^ n2;
        }

        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o;
            boolean bl = false;
            if ((this.key == null ? e2.getKey() == null : this.key.equals(e2.getKey())) && (this.value == null ? e2.getValue() == null : this.value.equals(e2.getValue()))) {
                bl = true;
            }
            return bl;
        }

        public final Object setValue(Object val) {
            Object retVal = this.value;
            this.value = val;
            return retVal;
        }

        private Node() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Values
    extends AbstractCollection {
        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        private Values() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class EntrySet
    extends AbstractSet {
        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean contains(Object o) {
            Map.Entry entry = (Map.Entry)o;
            int hash = StaticBucketMap.this.getHash(entry.getKey());
            Lock lock = StaticBucketMap.this.m_locks[hash];
            synchronized (lock) {
                Node n = StaticBucketMap.this.m_buckets[hash];
                while (n != null) {
                    if (n.equals(entry)) {
                        return true;
                    }
                    n = n.next;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            int hash = StaticBucketMap.this.getHash(entry.getKey());
            Lock lock = StaticBucketMap.this.m_locks[hash];
            synchronized (lock) {
                Node n = StaticBucketMap.this.m_buckets[hash];
                while (n != null) {
                    if (n.equals(entry)) {
                        StaticBucketMap.this.remove(n.getKey());
                        return true;
                    }
                    n = n.next;
                }
                return false;
            }
        }

        private EntrySet() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class KeyIterator
    extends EntryIterator {
        public Object next() {
            return this.nextEntry().getKey();
        }

        private KeyIterator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ValueIterator
    extends EntryIterator {
        public Object next() {
            return this.nextEntry().getValue();
        }

        private ValueIterator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class EntryIterator
    implements Iterator {
        private ArrayList current;
        private int bucket;
        private Map.Entry last;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public boolean hasNext() {
            if (this.current.size() <= 0) ** GOTO lbl15
            return true;
lbl-1000:
            // 1 sources

            {
                var1_1 = StaticBucketMap.access$1(StaticBucketMap.this)[this.bucket];
                // MONITORENTER : var1_1
                {
                    n = StaticBucketMap.access$0(StaticBucketMap.this)[this.bucket];
                    while (n != null) {
                        this.current.add(n);
                        n = n.next;
                    }
                    ++this.bucket;
                    if (this.current.size() <= 0) continue;
                    // MONITOREXIT : var1_1
                    return true;
                }
lbl15:
                // 2 sources

                ** while (this.bucket < StaticBucketMap.access$0((StaticBucketMap)StaticBucketMap.this).length)
            }
lbl16:
            // 1 sources

            return false;
        }

        protected Map.Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = (Map.Entry)this.current.remove(this.current.size() - 1);
            return this.last;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            StaticBucketMap.this.remove(this.last.getKey());
            this.last = null;
        }

        private final /* synthetic */ void this() {
            this.current = new ArrayList();
        }

        private EntryIterator() {
            this.this();
        }
    }
}

