/***************************************************************************
 *   Copyright (C) 2003 by Miguel Revilla Rodrguez                        *
 *   yo@miguelrevilla.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

 #include "libcdg123.h"
 
 int cdgFrameToRGBA(struct cdgStream *stream, unsigned char *RGBABuffer) {
 
 	int i,j ;
	int line ;
 
 	/* First we copy the frame info */
	
	for(i=0; i<CDG_RGBAFRAMESIZE; i+=4) {
	
			RGBABuffer[i  ] = stream->colorTable[stream->pixelMatrix[i/4]][0] ;
			RGBABuffer[i+1] = stream->colorTable[stream->pixelMatrix[i/4]][1] ;
			RGBABuffer[i+2] = stream->colorTable[stream->pixelMatrix[i/4]][2] ;
			
			if(stream->transparentColor == stream->pixelMatrix[i/4] && stream->transparentColor != 16)
				RGBABuffer[i+3] = 255 ; 
			else
				RGBABuffer[i+3] = 0 ;
	}
	
	/* Now we draw the border, set to black by default */
	
	for(i=0; i<CDG_FRAMEWIDTH * CDG_BORDERHEIGHT * 4; i+=4) {

		RGBABuffer[i  ] = stream->colorTable[stream->borderColor][0] ;
		RGBABuffer[i+1] = stream->colorTable[stream->borderColor][1] ;
		RGBABuffer[i+2] = stream->colorTable[stream->borderColor][2] ;

		if(stream->transparentColor == stream->borderColor && stream->transparentColor != 16)
			RGBABuffer[i+3] = 255 ; 
		else
			RGBABuffer[i+3] = 0 ;

		j = i + (CDG_FRAMEWIDTH * CDG_FRAMEHEIGHT * 4) - (CDG_FRAMEWIDTH * CDG_BORDERHEIGHT * 4) ;
		
		RGBABuffer[j  ] = stream->colorTable[stream->borderColor][0] ;
		RGBABuffer[j+1] = stream->colorTable[stream->borderColor][1] ;
		RGBABuffer[j+2] = stream->colorTable[stream->borderColor][2] ;

		if(stream->transparentColor == stream->borderColor && stream->transparentColor != 16)
			RGBABuffer[j+3] = 255 ; 
		else
			RGBABuffer[j+3] = 0 ;
			
	}
	
	for(line = CDG_BORDERHEIGHT ; line < CDG_FRAMEHEIGHT - CDG_BORDERHEIGHT ; line++) {
	
		for(i=0+(line*CDG_FRAMEWIDTH*4) ; i < (line*CDG_FRAMEWIDTH*4)+(CDG_BORDERWIDTH*4) ; i+=4) {
			RGBABuffer[i  ] = stream->colorTable[stream->borderColor][0] ;
			RGBABuffer[i+1] = stream->colorTable[stream->borderColor][1] ;
			RGBABuffer[i+2] = stream->colorTable[stream->borderColor][2] ;

			if(stream->transparentColor == stream->borderColor && stream->transparentColor != 16)
				RGBABuffer[i+3] = 255 ; 
			else
				RGBABuffer[i+3] = 0 ;

			j = i + (CDG_FRAMEWIDTH * 4) - (CDG_BORDERWIDTH * 4) ;
		
			RGBABuffer[j  ] = stream->colorTable[stream->borderColor][0] ;
			RGBABuffer[j+1] = stream->colorTable[stream->borderColor][1] ;
			RGBABuffer[j+2] = stream->colorTable[stream->borderColor][2] ;

			if(stream->transparentColor == stream->borderColor && stream->transparentColor != 16)
				RGBABuffer[j+3] = 255 ; 
			else
				RGBABuffer[j+3] = 0 ;
		}
	}
	
	return 0 ;
}
 
