/*
 * Copyright (C) 2004--2008  Enrico Zini <enrico@enricozini.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <buffy/config/storage.h>
#include <tests/test-utils.h>

namespace tut {
using namespace buffy::config;
using namespace wibble::tests;

struct buffy_config_storage_shar {
	Storage st;
	buffy_config_storage_shar() {
		st.initEmpty("buffy");
		st.addDefault("nick", "enrico");
		st.addDefault("view/empty", "true");
		st.addDefault("view/time", "10");
	}
	~buffy_config_storage_shar() {
		unlink("test-config-saved.txt");
	}
};
TESTGRP(buffy_config_storage);

// Test escaping functions
template<> template<>
void to::test<1>()
{
	ensure_equals(Storage::unescape(Storage::escape("foo")), "foo");
	ensure_equals(Storage::unescape(Storage::escape("f%oo")), "f%oo");
	ensure_equals(Storage::unescape(Storage::escape("f/oo")), "f/oo");
	ensure_equals(Storage::unescape(Storage::escape("f[o]o")), "f[o]o");
	ensure_equals(Storage::unescape(Storage::escape("f[o]o%")), "f[o]o%");
	ensure_equals(Storage::unescape(Storage::escape("f[o]o/")), "f[o]o/");
}

// Check string values
template<> template<>
void to::test<2>()
{
	// No initial default
	ensure_equals(st.get("name"), "");
	st.set("name", "Enrico");
	ensure_equals(st.get("name"), "Enrico");
	st.unset("name");
	ensure_equals(st.get("name"), "");

	// Setting an initial default
	st.addDefault("name", "Enrico");
	ensure_equals(st.get("name"), "Enrico");
	st.set("name", "Maurizio");
	ensure_equals(st.get("name"), "Maurizio");
	st.unset("name");
	ensure_equals(st.get("name"), "Enrico");

	// With initial default
	ensure_equals(st.get("nick"), "enrico");
	st.set("nick", "tanno");
	ensure_equals(st.get("nick"), "tanno");
	st.unset("nick");
	ensure_equals(st.get("nick"), "enrico");
}

// Check bool values
template<> template<>
void to::test<3>()
{
	// No initial default
	ensure_equals(st.getBool("view/read"), false);
	st.setBool("view/read", true);
	ensure_equals(st.getBool("view/read"), true);
	st.unset("view/read");
	ensure_equals(st.getBool("view/read"), false);

	// Setting an initial default
	st.addDefault("view/read", "true");
	ensure_equals(st.getBool("view/read"), true);
	st.setBool("view/read", false);
	ensure_equals(st.getBool("view/read"), false);
	st.unset("view/read");
	ensure_equals(st.getBool("view/read"), true);

	// With initial default
	ensure_equals(st.getBool("view/empty"), true);
	st.setBool("view/empty", false);
	ensure_equals(st.getBool("view/empty"), false);
	st.unset("view/empty");
	ensure_equals(st.getBool("view/empty"), true);
}

// Check int values
template<> template<>
void to::test<4>()
{
	// No initial default
	ensure_equals(st.getInt("view/pause"), 0);
	st.setInt("view/pause", 10);
	ensure_equals(st.getInt("view/pause"), 10);
	st.unset("view/pause");
	ensure_equals(st.getInt("view/pause"), 0);

	// Setting an initial default
	st.addDefault("view/pause", "10");
	ensure_equals(st.getInt("view/pause"), 10);
	st.setInt("view/pause", 5);
	ensure_equals(st.getInt("view/pause"), 5);
	st.unset("view/pause");
	ensure_equals(st.getInt("view/pause"), 10);

	// With initial default
	ensure_equals(st.getInt("view/time"), 10);
	st.setInt("view/time", 5);
	ensure_equals(st.getInt("view/time"), 5);
	st.unset("view/time");
	ensure_equals(st.getInt("view/time"), 10);
}

// Check that no autovivification is happening
template<> template<>
void to::test<7> ()
{
	// Start with just defaults
	Storage st0;
	st0.initEmpty("moo");

	st0.addDefault("prova", "300");

	// Access the default value
	ensure_equals(st0.getInt("prova"), 300);
	ensure(! st0.isSet("prova"));

	// Save and reload
	st0.save("test-config-saved.txt");
	Storage st1;
	st1.load("test-config-saved.txt");

	// Check that the default value didn't get saved
	ensure_equals(st1.isSet("prova"), false);
}

}

// vim:set ts=4 sw=4:
