#!/usr/bin/ruby -I../ruby

require 'Buffy'
require 'test/unit'
require 'pp'

class TC_Buffy_Config < Test::Unit::TestCase
	def setup
		@config = Buffy::Config.new("test-config.txt")
	end

	# def teardown
	# end

	# Test Config
	def test_config
		assert_not_nil(@config)

		assert_equal(@config.view.read, false)
		assert_equal(@config.view.empty, false)
		assert_equal(@config.view.important, true)
		assert_equal(@config.general.interval, 600)

		locations = @config.locations.get
		assert_equal(locations.size, 4)

		programs = @config.mailPrograms.getInfo
		assert_equal(programs.size, 3)

		assert_equal(@config.mailPrograms.selected.name, "Mutt")

        @config.mailProgram("mutt").addDefault("selected", "true")

		folder = @config.folder("foo")
		assert_equal(folder.forceview, true)
		assert_equal(folder.forcehide, false)
        folder.setForceHide(true)
        assert_equal(folder.forceview, false)
        assert_equal(folder.forcehide, true)

		folder = @config.folder("bar")
		assert_equal(folder.forceview, false)
		assert_equal(folder.forcehide, true)
        folder.setForceView(true)
        assert_equal(folder.forceview, true)
        assert_equal(folder.forcehide, false)
	end
end

class TC_Buffy_Maildir < Test::Unit::TestCase
	# Check an empty maildir
	def test_empty
		test = Buffy::MailFolder.accessFolder("maildir/empty")
		assert_equal(test.valid, true)
		assert_equal(test.name, "empty")
		assert_equal(test.path, "maildir/empty")
		assert_equal(test.type, "Maildir")

		assert_equal(test.getMsgTotal, -1)
		assert_equal(test.getMsgUnread, -1)
		assert_equal(test.getMsgNew, -1)
		assert_equal(test.getMsgFlagged, -1)
		assert_equal(test.changed, true)

		test.updateStatistics
		assert_equal(test.getMsgTotal, 0)
		assert_equal(test.getMsgUnread, 0)
		assert_equal(test.getMsgNew, 0)
		assert_equal(test.getMsgFlagged, 0)
		assert_equal(test.changed, false)

		folders = Buffy::MailFolder::enumerateFolders "maildir/empty"
		assert_equal(folders.length, 1)
	end

	# Check a non empty maildir
	def test_nonempty
		test = Buffy::MailFolder.accessFolder "maildir/test"
		assert_equal(test.valid, true)
		assert_equal(test.name, "test")
		assert_equal(test.path, "maildir/test")
		assert_equal(test.type, "Maildir")

		assert_equal(test.getMsgTotal, -1)
		assert_equal(test.getMsgUnread, -1)
		assert_equal(test.getMsgNew, -1)
		assert_equal(test.getMsgFlagged, -1)
		assert_equal(test.changed, true)

		test.updateStatistics
		assert_equal(test.getMsgTotal, 3)
		assert_equal(test.getMsgUnread, 0)
		assert_equal(test.getMsgNew, 0)
		assert_equal(test.getMsgFlagged, 1)
		assert_equal(test.changed, false)

		folders = Buffy::MailFolder::enumerateFolders "maildir/test"
		assert_equal(folders.length, 1)
	end

	# Check a maildir whose root is a broken symlink
	def test_broken
		test = Buffy::MailFolder.accessFolder "maildir/broken"
		assert_equal(test.valid, false)

		folders = Buffy::MailFolder::enumerateFolders "maildir/broken"
		assert_equal(folders.length, 0)
	end

	# Check a maildir whose cur, new and tmp directories are broken symlinks
	def test_broken1
		test = Buffy::MailFolder.accessFolder "maildir/broken1"
		assert_equal(test.valid, false)

		folders = Buffy::MailFolder::enumerateFolders "maildir/broken1"
		assert_equal(folders.length, 0)
	end

	# Check a maildir whose root is a symlink pointing to a nonexisting directory
	def test_loop
		test = Buffy::MailFolder.accessFolder "maildir/loop"
		assert_equal(test.valid, false)

		folders = Buffy::MailFolder.enumerateFolders "maildir/loop"
		assert_equal(folders.length, 0)
	end

	# Check a maildir which has a submaildir that is a symlink pointing up
	def test_loop1
		test = Buffy::MailFolder.accessFolder "maildir/loop1"
		assert_equal(test.valid, true)

		folders = Buffy::MailFolder.enumerateFolders "maildir/loop1"
		assert_equal(folders.length, 1)
	end

	# Check maildir enumeration
	def test_enumeration
		folders = Buffy::MailFolder.enumerateFolders "maildir"
		assert_equal(folders.length, 4)
	end
end

class TC_Buffy_Mailbox < Test::Unit::TestCase
	# Check an empty mailbox
	def test_empty
		test = Buffy::MailFolder.accessFolder "mbox/empty.mbox"
		assert_equal(test.valid, true)
		assert_equal(test.name, "empty.mbox")
		assert_equal(test.path, "mbox/empty.mbox")
		assert_equal(test.type, "Mailbox")

		assert_equal(test.getMsgTotal, -1)
		assert_equal(test.getMsgUnread, -1)
		assert_equal(test.getMsgNew, -1)
		assert_equal(test.getMsgFlagged, -1)
		assert_equal(test.changed, true)

		test.updateStatistics
		assert_equal(test.getMsgTotal, 0)
		assert_equal(test.getMsgUnread, 0)
		assert_equal(test.getMsgNew, 0)
		assert_equal(test.getMsgFlagged, 0)
		assert_equal(test.changed, false)

		folders = Buffy::MailFolder.enumerateFolders "mbox/empty.mbox"
		assert_equal(folders.length, 1)
	end

	# Check a non empty mailbox
	def test_nonempty
		test = Buffy::MailFolder.accessFolder "mbox/test.mbox"
		assert_equal(test.valid, true)
		assert_equal(test.name, "test.mbox")
		assert_equal(test.path, "mbox/test.mbox")
		assert_equal(test.type, "Mailbox")

		assert_equal(test.getMsgTotal, -1)
		assert_equal(test.getMsgUnread, -1)
		assert_equal(test.getMsgNew, -1)
		assert_equal(test.getMsgFlagged, -1)
		assert_equal(test.changed, true)

		test.updateStatistics
		assert_equal(test.getMsgTotal, 3)
		assert_equal(test.getMsgUnread, 0)
		assert_equal(test.getMsgNew, 0)
		assert_equal(test.getMsgFlagged, 1)
		assert_equal(test.changed, false)

		folders = Buffy::MailFolder.enumerateFolders "mbox/test.mbox"
		assert_equal(folders.length, 1)
	end

	# Check a mailbox whose root is a broken symlink
	def test_broken
		test = Buffy::MailFolder.accessFolder "mbox/broken.mbox"
		assert_equal(test.valid(), false)

		folders = Buffy::MailFolder.enumerateFolders "mbox/broken.mbox"
		assert_equal(folders.length, 0)
	end

	# Check enumeration of a directory with mailboxes
	def test_enumeration
		folders = Buffy::MailFolder::enumerateFolders "mbox"
		assert_equal(folders.length, 2)
	end
end
