/* 
**  footer.c -- Apache layout module
**  $Revision: 1.2 $
*/

#include "mod_layout.h"

LAYOUT_EXPORT(void) layout_print(request_rec *r, layout_conf *cfg, layout_request *info, int x) {
	int status = OK;
	layout_string **layouts;
	int assbackwards = 0;

	layouts = (layout_string **) cfg->layouts->elts;

#ifdef DEBUG
	if (layouts[x]->kind == FOOTER)
		printf("Calling Footer %s\n", layouts[x]->comment);
	else if (layouts[x]->kind == LAYOUT)
		printf("Calling Layout %s\n", layouts[x]->comment);
	else if (layouts[x]->kind == HEADER)
		printf("Calling Header %s\n", layouts[x]->comment);
#endif

	if (layouts[x]->kind == HEADER) {
		if(isOn(cfg->comment)){
			unless((x == 0 && (info->http == HEADER)))
				ap_rprintf(r, "\n\n<!-- Beginning of: %s -->\n\n", layouts[x]->comment);
		}
	} else {
		if (isOn(cfg->comment)) 
			ap_rprintf(r, "\n\n<!-- Beginning of: %s -->\n\n", layouts[x]->comment);
	}

	if (layouts[x]->type > 0){ 
		ap_rputs(layouts[x]->string, r);
	} else {
		if(x == 0 && (info->http == HEADER)) {
			assbackwards = 0;
		} else {
			assbackwards = 1;
		}

		if ((status = call_container(r, layouts[x]->string, cfg, info, assbackwards)) != OK) { 
			ap_log_rerror(APLOG_MARK, APLOG_NOERRNO | APLOG_ERR, r, "The following error occured while processing the Layout : %d", status);
		}
	}

	if (isOn(cfg->comment)) 
		ap_rprintf(r, "\n\n<!-- End of: %s -->\n\n", layouts[x]->comment );
}
