
/* ====================================================================
 *
 * MOD_GZIP.C - Version 1.3.26.1a
 *
 * This program was developed by
 *
 * Remote Communications, Inc.
 * Home page: http://www.RemoteCommunications.com
 *
 * and is currently maintained by
 *
 * Christian Kruse, <ckruse@wwwtech.de> and Michael Schroepl,
 * <michael@schroepl.net>
 * Home page: http://sourceforge.net/projects/mod-gzip/
 *
 * Original author: Kevin Kiley, CTO, Remote Communications, Inc.
 * Email: Kiley@RemoteCommunications.com
 *
 * As of this writing there is an online support forum which
 * anyone may join by following the instructions found at...
 * http://lists.over.net/mailman/listinfo/mod_gzip
 *
 * ====================================================================
 */

/* APACHE LICENSE: START
 *
 * Portions of this software are covered under the following license
 * which, as it states, must remain included in this source code
 * module and may not be altered in any way.
 */

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * Portions of this software are based upon public domain software
 * originally written at the National Center for Supercomputing Applications,
 * University of Illinois, Urbana-Champaign.
 */

/* APACHE LICENSE: END */

#ifndef _MOD_GZIP_H
#define _MOD_GZIP_H

#define MOD_GZIP_VERSION_INFO_STRING "mod_gzip/1.3.26.1a"

/*
 * Declare the NAME by which this module will be known.
 * This is the NAME that will be used in LoadModule command(s).
 */

extern module MODULE_VAR_EXPORT gzip_module;

/*
 * Turn MOD_GZIP_USES_APACHE_LOGS switch ON to include the
 * code that can update Apache logs with compression information.
 */

#define MOD_GZIP_USES_APACHE_LOGS

/*
 * Turn MOD_GZIP_DEBUG1 switch ON to include debug code.
 * This is normally OFF by default and should only be
 * used for diagnosing problems. The log output is
 * VERY detailed and the log files will be HUGE.
 */

/*
#define MOD_GZIP_DEBUG1
*/

/*
 * Turn MOD_GZIP_DEBUG1_VERBOSE1 switch ON to include
 * some VERY 'verbose' debug code such as request record
 * dumps during transactions and hex dumps of data.
 * This is normally OFF by default. MOD_GZIP_DEBUG1
 * switch must also be 'on' for this to have any effect.
 */

#ifdef  MOD_GZIP_DEBUG1
#define MOD_GZIP_DEBUG1_VERBOSE1
#endif

/*
 * Turn this 'define' on to send all log output to
 * Apache error_log instead of a flat file. "LogLevel debug"
 * must be set in httpd.conf for log output to appear in error_log.
 */

/*
#define MOD_GZIP_LOG_IS_APACHE_LOG
*/

/*
 * Other globals...
 */

#ifndef MOD_GZIP_MAX_PATH_LEN
#define MOD_GZIP_MAX_PATH_LEN 512
#endif

#define MOD_GZIP_IMAP_MAXNAMES   256
#define MOD_GZIP_IMAP_MAXNAMELEN 90

#define MOD_GZIP_IMAP_ISNONE      0
#define MOD_GZIP_IMAP_ISMIME      1
#define MOD_GZIP_IMAP_ISHANDLER   2
#define MOD_GZIP_IMAP_ISFILE      3
#define MOD_GZIP_IMAP_ISURI       4
#define MOD_GZIP_IMAP_ISREQHEADER 5
#define MOD_GZIP_IMAP_ISRSPHEADER 6
#define MOD_GZIP_IMAP_ISPORT      7
#define MOD_GZIP_IMAP_ISADDRESS   8

#define MOD_GZIP_IMAP_STATIC1     9001
#define MOD_GZIP_IMAP_DYNAMIC1    9002
#define MOD_GZIP_IMAP_DYNAMIC2    9003
#define MOD_GZIP_IMAP_DECLINED1   9004

#define MOD_GZIP_REQUEST          9005
#define MOD_GZIP_RESPONSE         9006

typedef struct {
    int      include;   
    int      type;      
    int      action;    
    int      direction; 
    unsigned port;      
    int      len1;      
    regex_t *pregex;    

    char name[ MOD_GZIP_IMAP_MAXNAMELEN + 2 ];
    int  namelen; 
} mod_gzip_imap;

extern int mod_gzip_imap_size;

#define MOD_GZIP_CONFIG_MODE_SERVER      1
#define MOD_GZIP_CONFIG_MODE_DIRECTORY   2
#define MOD_GZIP_CONFIG_MODE_COMBO       3

typedef struct {

    int  cmode;

    char *loc;                   

    int  is_on;                  
    int  is_on_set;

    int  keep_workfiles;         
    int  keep_workfiles_set;

    int  dechunk;                
    int  dechunk_set;

    int  add_header_count;       
    int  add_header_count_set;

    int  min_http;               
    int  min_http_set;

    long minimum_file_size;      
    int  minimum_file_size_set;

    long maximum_file_size;      
    int  maximum_file_size_set;

    long maximum_inmem_size;     
    int  maximum_inmem_size_set;

    char temp_dir[256]; /* Length is safety-checked during startup */
    int  temp_dir_set;

    int imap_total_entries;
    int imap_total_ismime;
    int imap_total_isfile;
    int imap_total_isuri;
    int imap_total_ishandler;
    int imap_total_isreqheader;
    int imap_total_isrspheader;

    mod_gzip_imap imap[ MOD_GZIP_IMAP_MAXNAMES + 1 ];

    #define MOD_GZIP_COMMAND_VERSION_USED
    #ifdef  MOD_GZIP_COMMAND_VERSION_USED
    #define MOD_GZIP_COMMAND_VERSION 8001
    #define MOD_GZIP_COMMAND_VERSION_MAXLEN 128
    char command_version[ MOD_GZIP_COMMAND_VERSION_MAXLEN + 1 ];
    int  command_version_set;
    #endif

    #define MOD_GZIP_CAN_NEGOTIATE
    #ifdef  MOD_GZIP_CAN_NEGOTIATE
    int can_negotiate;
    int can_negotiate_set;
    #endif

    #define MOD_GZIP_M_BOTH    -1
    #define MOD_GZIP_M_NOT_SET -2
    int handle_methods;

    #define MOD_GZIP_MAX_SUFFIX_LEN 5
    char suffix[MOD_GZIP_MAX_SUFFIX_LEN + 1];
    int  suffix_set;

    int  send_vary;
    int  send_vary_set;

    int  refresh_files;
    int  refresh_files_set;
} mod_gzip_conf;

extern long mod_gzip_iusn;

int mod_gzip_strncmp( char *s1, char *s2, int len1 );
int mod_gzip_strnicmp( char *s1, char *s2, int len1 );
int mod_gzip_strcpy( char *s1, char *s2 );
int mod_gzip_strcat( char *s1, char *s2 );
int mod_gzip_strlen( char *s1 );
int mod_gzip_stringcontains( char *source, char *substring );
int mod_gzip_strendswith( char *s1, char *s2, int ignorcase );

int mod_gzip_create_unique_filename(
char *prefix,
char *target,
int   targetmaxlen
);

int mod_gzip_delete_file(
request_rec   *r,
char          *filename
);

int mod_gzip_flush_and_update_counts(
request_rec   *r,
mod_gzip_conf *dconf,
long           total_header_bytes_sent,
long           total_body_bytes_sent
);

long mod_gzip_sendfile1(
request_rec *r,
char        *input_filename,
FILE        *ifh_passed,
long         starting_offset
);

int mod_gzip_sendfile2(
request_rec   *r,
mod_gzip_conf *dconf,
char          *input_filename
);

int mod_gzip_dyn1_getfdo1(
request_rec *r,
char        *filename
);

int mod_gzip_redir1_handler(
request_rec   *r,
mod_gzip_conf *dconf
);

long mod_gzip_send(
char        *buf,
long         buflen,
request_rec *r
);

int mod_gzip_encode_and_transmit(
request_rec   *r,
mod_gzip_conf *dconf,
char          *source,
int            source_is_a_file,
long           input_size,
int            nodecline,
long           header_length,
char          *result_prefix_string
);

typedef struct _GZP_CONTROL {

    int   decompress;

    int   input_ismem;          
    char *input_ismem_ibuf;     
    long  input_ismem_ibuflen;  

    char  input_filename[ MOD_GZIP_MAX_PATH_LEN + 2 ]; 

    long  input_offset;         

    int   output_ismem;         
    char *output_ismem_obuf;    
    long  output_ismem_obuflen; 

    char  output_filename[ MOD_GZIP_MAX_PATH_LEN + 2 ]; 

    int   result_code; 
    long  bytes_out;   

} GZP_CONTROL;

int gzp_main(request_rec *, GZP_CONTROL *); 
char *mod_gzip_generate_vary_header(mod_gzip_conf *,struct pool *);
int mod_gzip_compress_file(request_rec *,char *);


struct _table {
    array_header a;
#ifdef MAKE_TABLE_PROFILE
    void *creator;
#endif
};
typedef struct _table _table;

#endif
