#!/bin/sh

if [ "$1" = "" ] || [ "$2" = "" ]; then
    if [ `whoami` =  "root" ]; then
	echo "Usage: secure_modfix web_admin_user apache_user_group"
	exit 0
    else
	echo "WARNING: Optimally run as root"
	echo "Assuming you are running as the web user..."
	NOTROOT='1'
    fi
fi

echo "Creating symbolic links and setting permissions as needed."
[ -n "$NOTROOT" ] && chown $1:$2 site.ini
chmod 640 site.ini
if [ -f "override/site.ini" ]; then
    [ -n "$NOTROOT" ] && chown $1:$2 override/site.ini
    chmod 640 override/site.ini
fi
if [ -f "override/site.ini.append" ]; then
    [ -n "$NOTROOT" ] && chown $1:$2 override/site.ini.append
    chmod 640 override/site.ini.append
fi

touch error.log
chmod 660 error.log
[ -n "$NOTROOT" ] && chown $1:$2 error.log

# [cache section]
# This part will create the cache dirs which are needed and make sure
# that they are writeable by php.

dirs="
admin/tmp
classes/cache
ezad/admin/cache
ezaddress/admin/cache
ezarticle/admin/cache
ezarticle/cache
ezbug/admin/cache
ezbug/user/cache
ezbulkmail/admin/cache
ezcalendar/admin/cache
ezcalendar/user/cache
ezcontact/admin/cache
ezfilemanager/admin/cache
ezfilemanager/files
ezform/admin/cache
ezforum/admin/cache
ezforum/cache
ezimagecatalogue/admin/cache
ezimagecatalogue/catalogue
ezimagecatalogue/catalogue/variations
ezlink/admin/cache
ezlink/cache
ezmediacatalogue/admin/cache
ezmediacatalogue/cache
ezmediacatalogue/catalogue
ezmessage/admin/cache
eznewsfeed/admin/cache
eznewsfeed/cache
ezpoll/admin/cache
ezpoll/cache
ezquiz/admin/cache
ezquiz/cache
ezsitemanager/admin/cache
ezsitemanager/staticfiles
ezsitemanager/staticfiles/images
ezstats/admin/cache
eztodo/admin/cache
eztrade/admin/cache
eztrade/cache
ezurltranslator/admin/cache
ezuser/admin/cache
"

for dir in $dirs
do
    if [ -d $dir ]; then
	    echo "$dir already exist"
    else
        echo "Creating $dir"
	    mkdir -p $dir
    fi
    [ -n "$NOTROOT" ] && chown $1:$2 $dir
    chmod 770 $dir   
done

for dir in $dirs
do
    override_dir="override/"$dir
    if [ -d $override_dir ]; then
	chmod 770 $override_dir
    fi
done
