/*
 * socket.h
 */
 
#ifndef __SOCKET_H
#   define __SOCKET_H

#include <sys/types.h>
#include <unistd.h>

#ifdef HAVE_POLL_H
#   include <poll.h>
#elif HAVE_SYS_POLL_H
#   include <sys/poll.h>
#else

    #ifndef USE_SELECT
    #define USE_SELECT
    #endif

    #ifdef HAVE_SYS_SELECT_H
    #include <sys/select.h>
    #endif

struct pollfd
{
    int fd;                     /* File descriptor to poll.  */
    short int events;           /* Types of events poller cares about.  */
    short int revents;          /* Types of events that actually occurred.  */
};

#define POLLIN          0x001           /* There is data to read.  */
#define POLLPRI         0x002           /* There is urgent data to read.  */
#define POLLOUT         0x004           /* Writing now will not block.  */
#define POLLERR         0x008           /* Error condition.  */
#define POLLHUP         0x010           /* Hung up.  */
#define POLLNVAL        0x020           /* Invalid polling request.  */
#endif

#include "linkedlist.h"

     
class pollsocket
{
protected:
    int fd;

    static linkedlist<pollsocket> list;
    static int num_socks;

#ifdef USE_SELECT
    static fd_set fds_read, fds_write;
    static fd_set res_read, res_write;
    static int highest_fd;
#else
    static int num_pfds;
    static pollfd * pfds;
    static struct pollfd * find_empty_slot();
    int idx;
#endif



public:
    pollsocket(int f, int events = POLLIN | POLLOUT);
    virtual ~pollsocket();
    virtual int event_handler(const struct pollfd *) = 0;
    
    static  int poll_all(int );
    static  int compress(void);
    int close(void);
    int set_events(int);
    int set_revents(int);
    
#ifdef USE_SELECT
    int revents() const;
    int revents(int) const;
#else
    /* Returns the result flags */
    int revents() const
    {
        if (fd > -1)
            return pfds[idx].revents;
        return 0;
    }

    /* Tries to match a result flag */
    int revents(int r) const
    {
        if (fd > -1)
            return (pfds[idx].revents & r);
        return 0;
    }
#endif
    
};

#endif
