/*
 *   (C) Copyright IBM Corp. 2006
 *   (C) Copyright ALT Linux Ltd. 2006
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: FAT FSIM
 * File: evms2/engine/plugins/fat/utils.h
 */

#ifndef _UTIL_H_
#define _UTIL_H_ 1

/**
 * struct msdos_volume_info
 *
 * @drive_number: BIOS drive number
 * @RESERVED: Unused
 * @ext_boot_sign: 0x29 if fields below exist (DOS 3.3+)
 * @volume_id: Volume ID number
 * @volume_label: Volume label
 * @fs: Typically FAT12 or FAT16
 *
 * FAT boot sector structure.
 **/
struct msdos_volume_info {
	u_int8_t	drive_number;
	u_int8_t	RESERVED;
	u_int8_t	ext_boot_sign;
	u_int32_t	volume_id;
	u_int8_t	volume_label[11];
	u_int8_t	fs[8];
} __attribute__ ((packed));

/**
 * struct fat_boot_sector
 *
 * @ignored
 * @system_id: Name - can be used to special-case partition manager volumes.
 * @sector_size: Bytes per logical sector.
 * @cluster_size: Sectors per cluster.
 * @reserved
 * @fats: Number of FATs.
 * @dir_entries: Root directory entries.
 * @sectors: Number of sectors.
 * @media: Media code (unused).
 * @fat_length: Sectors per FAT.
 * @secs_track: Sectors per track.
 * @heads: Number of heads.
 * @hidden: Hidden sectors (unused).
 * @total_sect: Number of sectors (if 'sectors' == 0).
 * @fat32.length: Sectors per FAT.
 * @fat32.flags: Bit 8: FAT mirroring, Low 4 bits: Active FAT.
 * @fat32.version: Major, minor filesystem version.
 * @fat32.root_cluster: First cluster in root directory.
 * @fat32.info_sector: Filesystem info sector.
 * @fat32.backup_boot: Backup boot sector.
 * @fat32.reserved2: Unused.
 * @fat32.vi
 **/
typedef struct {
	u_int8_t	ignored[3];
	u_int8_t	system_id[8];
	u_int16_t	sector_size;
	u_int8_t	cluster_size;
	u_int16_t	reserved;
	u_int8_t	fats;
	u_int8_t	dir_entries[2];
	u_int16_t	sectors;
	u_int8_t	media;
	u_int16_t	fat_length;
	u_int16_t	secs_track;
	u_int16_t	heads;
	u_int32_t	hidden;
	u_int32_t	total_sect;
	union {
		struct {
			struct msdos_volume_info vi;
			//u_int8_t	fs[8];
			u_int16_t	reserved2[14];
		} __attribute__ ((packed)) fat;
		struct {
			/* The following fields are only used by FAT32 */
			u_int32_t	length;
			u_int16_t	flags;
			u_int8_t	version[2];
			u_int32_t	root_cluster;
			u_int16_t	info_sector;
			u_int16_t	backup_boot;
			u_int16_t	reserved2[6];
			struct msdos_volume_info vi;
			//u_int8_t	fs[8];
		} __attribute__ ((packed)) fat32;
	};

	/* Fill up to 512 bytes */
	u_int8_t	junk[422];
} __attribute__ ((packed)) fat_boot_sector;

extern int get_fat_boot(int isfat16, logical_volume_t *ev,
			fat_boot_sector *boot);

extern int clear_fat_boot_sectors(logical_volume_t *ev);

extern int try_run(char *prog_name);

extern int get_fs_limits(logical_volume_t *vol,
			 sector_count_t *min_fs_size,
			 sector_count_t *max_fs_size,
			 sector_count_t *max_vol_size);

void free_private_data(logical_volume_t *vol);

extern int fill_private_data(int isfat16,
			     logical_volume_t *vol,
			     const fat_boot_sector *boot);

extern int resize_fat(int isfat16,
		      logical_volume_t *volume,
		      sector_count_t *new_size);

#endif

