/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libdos.so
 *
 *   File: checks.h
 */

#ifndef CHECKS_HEADER
#define CHECKS_HEADER 1

boolean     isa_data_partition_record(struct partition *p);
boolean     isa_linux_raid_partition_record(struct partition *p);
boolean     isa_zero_length_partition_record(struct partition *p);
boolean     isa_null_partition_record(struct partition *p);
boolean     isa_ebr_partition_record(struct partition *p);
boolean     ptable_has_data_partition_record( Master_Boot_Record *mbr );
boolean     isa_mbr_partition_record(struct partition *p);
boolean     ptable_has_partition_records( LOGICALDISK *ld, Master_Boot_Record *mbr );
boolean     isa_linux_swap_partition_record(LOGICALDISK *ld, struct partition *p, lba_t extd_partition_offset);
boolean     has_guid_partition_table( Master_Boot_Record *mbr );
boolean     has_msdos_signature( Master_Boot_Record *mbr );
int         isa_valid_partition_table_chain( LOGICALDISK        *ld,
                                             Master_Boot_Record *mbr,
                                             lba_t               mbr_lba,
                                             lba_t               extd_partition_lba,
                                             boolean             ebr_chaining,
                                             int                 logical_count,
                                             boolean             final_call );

boolean     partition_record_uses_lba_addressing( LOGICALDISK *ld, struct partition *part );
boolean     disk_uses_lba_addressing( LOGICALDISK *ld );

#endif

