/*
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __LOCAL_DSK_CACHE_H__
#define __LOCAL_DSK_CACHE_H__ 1

extern int initialize_cache(void);
extern void purge_cache(void);
extern void destroy_cache(void);
extern int read_from_cache(storage_object_t * disk,
			   lsn_t sector,
			   sector_count_t count,
			   void * buffer);
extern int write_to_cache(storage_object_t * disk,
			  lsn_t sector,
			  sector_count_t count,
			  void * buffer);

#endif

