/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */ 

/**
 *	struct queued_message - contains info on a queued informational message
 *	@number: the message number
 *	@message: the message text
 *	@timestamp: the time the message was received/queued
 *
 *	This structure holds some information about informational messages queued
 *	during activities such as engine discovery and commit time.
 */
struct queued_message {
	int number;
	gchar *message;
	time_t timestamp;
};

/**
 *	struct alert_choice_info - contains info needed when alert choice is activated
 *	@return_selection: the address of where to update the return selection
 *	@our_index: the index for our choice
 *
 *	This structure is associated with each menu item choice for an alert
 *	message. It allows the menu item activation callback to set the index
 *	of the choice selected when that choice is activated.
 */
struct alert_choice_info {
	int *return_selection;
	int our_index;
};

void enable_message_queuing(void);
void disable_message_queuing(void);
void display_queued_messages(void);
int report_progress(progress_t *progress);
int show_user_message(char *message, int *choice_selection, char **choices);
int on_view_messages_menuitem_activated(struct menu_item *item);

