/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 */

/*
 * Global data exported by internalAPI.c
 */

extern engine_functions_t engine_functions;

/*
 * Global functions exported by internalAPI.c
 */

extern int engine_get_plugin_list(plugin_type_t         type,
                                  plugin_search_flags_t flags,
                                  list_anchor_t       * plugin_list);

extern int engine_get_plugin_by_ID(plugin_id_t         pluginID,
                                   plugin_record_t * * plugin);

extern int engine_get_plugin_by_name(char              * plugin_short_name,
                                     plugin_record_t * * plugin);

extern int engine_get_volume_list(plugin_record_t     * fsim,
				  storage_container_t * disk_group,
				  volume_search_flags_t flags,
				  list_anchor_t       * volume_list);

extern int engine_get_object_list(object_type_t         object_type,
                                  data_type_t           data_type,
                                  plugin_record_t     * plugin,
                                  storage_container_t * disk_group,
                                  object_search_flags_t flags,
                                  list_anchor_t       * objects);

extern int engine_get_container_list(plugin_record_t        * plugin,
				     storage_container_t * disk_group,
				     container_search_flags_t flags,
                                     list_anchor_t          * container_list);

extern int allocate_new_storage_object(storage_object_t * * new_object);

extern void free_old_storage_object(storage_object_t * obj);

extern int engine_allocate_logical_disk(char * name, storage_object_t * * new_disk);

extern int engine_free_logical_disk(storage_object_t * disk);

extern int engine_allocate_segment(char * name, storage_object_t * * new_segment);

extern int engine_free_segment(storage_object_t * segment);

extern int engine_allocate_region(char * name, storage_object_t * * new_region);

extern int engine_free_region(storage_object_t * region);

extern int engine_allocate_evms_object(char * name, storage_object_t * * new_object);

extern int engine_free_evms_object(storage_object_t * object);

extern int engine_free_storage_object(storage_object_t * obj);

extern int engine_allocate_container(char * name, storage_container_t * * new_container);

extern int engine_free_container(storage_container_t * container);

extern int engine_validate_name(char * name);

extern int engine_register_name(char * name);

extern int engine_unregister_name(char * name);

extern void clear_name_registry(void);

extern int engine_can_rename(storage_object_t * object);

extern boolean engine_can_online_copy(void);

extern boolean engine_is_offline(storage_object_t   * obj,
				 logical_volume_t * * vol);

extern pid_t engine_fork_and_execvp(logical_volume_t * vol,
				    char             * argv[],
				    int                stdin_pipe[2],
				    int                stdout_pipe[2],
				    int                stderr_pipe[2]);

int discard_volume(logical_volume_t * vol);

int engine_discard(list_anchor_t objects);

int engine_save_metadata(char     * parent,
			 char     * child,
			 u_int64_t  offset,
			 u_int64_t  length,
			 void     * metadata);
