/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: open_engine.c
 */

#ifndef _LVM_HELP_OPEN_ENGINE_
#define _LVM_HELP_OPEN_ENGINE_ 1

#include "print_message.c"

engine_message_functions_t message_functions;

/* Function: open_engine
 *
 *	Open the evms engine
 */
int open_engine(engine_mode_t	mode,
		debug_level_t	level )
{
	int rc;

	if ( opts.verbose ) {
		printf("%s -- Opening the EVMS Engine. This may take a few moments.\n", cmd);
	}

	message_functions.user_message = print_message;
	message_functions.user_communication = NULL;

	rc = evms_open_engine(mode, &message_functions, level, NULL);
	if (rc) {
		printf("%s -- Unable to open the EVMS Engine (%d)\n", cmd, rc);
		return rc;
	}

	if ( opts.verbose ) {
		printf("%s -- EVMS Engine opened.\n", cmd);
	}

	return 0;
}

#endif

