/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: get_freespace.c
 */ 

#ifndef _LVM_HELP_GET_FREESPACE_
#define _LVM_HELP_GET_FREESPACE_ 1

/* Function: get_freespace_for_container
 *
 *	Find the handle for the freespace region in the specified container.
 */
int get_freespace_for_container(object_handle_t	container,
				object_handle_t	* freespace )
{
	handle_object_info_t	* container_info;
	handle_object_info_t	* region_info;
	int			i,rc;

	if ( opts.verbose ) {
		printf("%s -- Searching for freespace region\n", cmd);
	}

	// Get the info for the container
	if ( (rc = evms_get_info(container, &container_info)) ) {
		printf("%s -- Error getting container info for handle %u\n", cmd, container);
		return rc;
	}

	// Search all regions in this container to find the freespace.
	for ( i = 0; i < container_info->info.container.objects_produced->count; i++ ) {
		if ( (rc = evms_get_info(container_info->info.container.objects_produced->handle[i], &region_info)) ) {
			printf("%s -- Error getting info for region %d in container %s\n", cmd, i, container_info->info.container.name);
			evms_free(container_info);
			return rc;
		}
		if ( region_info->info.region.data_type == FREE_SPACE_TYPE ) {
			*freespace = container_info->info.container.objects_produced->handle[i];
			if ( opts.verbose ) {
				printf("%s -- Found freespace region at handle %u\n", cmd, *freespace);
			}
			evms_free(container_info);
			evms_free(region_info);
			return 0;
		}
		evms_free(region_info);
	}

	printf("%s -- Could not find freespace region in container %s\n", cmd, container_info->info.container.name);
	evms_free(container_info);
	return ENODEV;
}

#endif

