/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: orm_commit.c
 *
 *
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <linux/evms/evms_os2.h>
#include <plugin.h>
#include "os2regmgr.h"
#include "orm_commit.h"



static int Commit_OS2_Compatibility_Region( storage_object_t *region, orm_private_data_t *pdata )
{
    int rc = EINVAL;

    LOGENTRY();


    LOGEXITRC();
    return rc;
}

static int Commit_OS2_LVM_Region( storage_object_t *region, orm_private_data_t *pdata )
{
    int rc = EINVAL;

    LOGENTRY();


    LOGEXITRC();
    return rc;
}


int orm_commit_changes( storage_object_t * region, uint phase )
{
    int rc = EINVAL;
    orm_private_data_t *pdata;

    LOGENTRY();

    if ( orm_ican_modify( region ) == TRUE ) {

        if ( ( phase == 1 || phase ==2 ) &&
             ( region->flags & SOFLAG_DIRTY )) {

            pdata = ( orm_private_data_t * )region->private_data;

            if ( pdata->flags & COMPATIBILITY_VOLUME ) {

                rc = Commit_OS2_Compatibility_Region( region, pdata );

            }
            else {

                rc = Commit_OS2_LVM_Region( region, pdata );

            }

            if ( rc == 0 ) {
                region->flags &= ~SOFLAG_DIRTY;    // mark it clean now
            }

        }
        else {
            rc = 0;
        }

    }

    LOGEXITRC();
    return rc;
}

