/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_discover.h
 */

#ifndef _MD_DISCOVER_H_
#define _MD_DISCOVER_H_ 1

// Functions exported by md_discover.c

int md_check_for_pv(	storage_object_t * object, mdp_super_t ** buffer);
int md_discover_logical_volumes( void );
int md_discover_volumes( dlist_t input_list, dlist_t output_list);
int md_find_volume_for_object(storage_object_t * object, mdp_super_t *md_super_buffer);
int md_read_sb_from_disk(storage_object_t *object, mdp_super_t * buffer);
int md_write_sbs_to_disk(md_volume_t * volume);
int md_get_kernel_info(md_volume_t * volume, evms_md_array_info_t* md_info);
int md_uuids_equal(mdp_super_t * sb1, mdp_super_t * sb2);
int md_register_name_space(void);
#endif

