/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: lvmregmgr
 * File: lvm_names.h
 */ 

#ifndef _LVM_NAMES_H_
#define _LVM_NAMES_H_ 1

// Functions exported from lvm_names.c
extern int lvm_translate_vg_name_to_container_name(char	* vg_name,
						char	* container_name );
extern int lvm_translate_container_name_to_vg_name(char	* container_name,
						char	* vg_name );
extern int lvm_translate_lv_name_to_region_name(char	* lv_name,
						char	* region_name );
extern int lvm_translate_region_name_to_lv_name(char	* region_name,
						char	* lv_name );
extern int lvm_make_lv_name(	char			* simple_name,
				lvm_volume_group_t	* group,
				char			* lv_name );
extern int lvm_translate_dev_name(	char	* input,
					char	* output );

#endif

