/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#include "ppa/src/pp_array.h"

namespace esys
{
  namespace lsm
  {
    template <class TmplParticle>
    BodyForceGroup<TmplParticle>::BodyForceGroup(
      const BodyForceIGP &prms,
      ParticleArray &particleArray
    )
      : m_acceleration(prms.getAcceleration()),
        m_pParticleArray(&particleArray)
    {
    }

    template <class TmplParticle>
    BodyForceGroup<TmplParticle>::~BodyForceGroup()
    {
    }

    template <class TmplParticle>
    void BodyForceGroup<TmplParticle>::Update(ParallelParticleArray<TmplParticle> *particleArray)
    {
    }

    template <class TmplParticle>
    Vec3 BodyForceGroup<TmplParticle>::getForce(double mass) const
    {
      return m_acceleration*mass;
    }

    template <class TmplParticle>
    void BodyForceGroup<TmplParticle>::applyForce(TmplParticle &particle) const
    {
      particle.applyForce(getForce(particle.getMass()), particle.getPos());
    }

    template <class TmplParticle>
    void BodyForceGroup<TmplParticle>::calcForces()
    {
      typename ParticleArray::ParticleListHandle plh = m_pParticleArray->getAllParticles();
      for (
        ParticleIterator it = plh->begin();
        it != plh->end();
        it++
      )
      {
        applyForce(*(*it));
      }
    }
  }
}
