# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Compatibility module to use the KDE Progress Dialog instead of the Qt Progress Dialog.
"""

import os

import Preferences

try:
    raise ImportError
    # TODO: KDE 4
##    from kdeui import KProgressDialog
##    from qt import QString
##    
##    class KQProgressDialog(KProgressDialog):
##        """
##        Compatibility class to use the KDE Progress Dialog instead of the Qt Progress Dialog.
##        """
##        def __init__(self, labelText, cancelButtonText, totalSteps,
##                     parent = None, name = None, modal = 0, f = 0):
##            """
##            Constructor
##            
##            @param labelText text to show in the progress dialog
##            @param cancelButtonText text to show for the cancel button or
##                None to disallow cancellation and to hide the cancel button
##            @param totalSteps total number of steps for the progress bar
##            @param parent parent of the progress dialog
##            @param name name of the progress dialog
##            @param modal flag setting the modal state
##            @param f window flags (ignored)
##            """
##            KProgressDialog.__init__(self, parent, name, QString.null, labelText, modal)
##            self.bar = self.progressBar()
##            self.bar.setTotalSteps(totalSteps)
##            if cancelButtonText is QString.null or unicode(cancelButtonText) == "":
##                self.setAllowCancel(0)
##            else:
##                self.setButtonText(cancelButtonText)
##            
##        def setTotalSteps(self, totalSteps):
##            """
##            Public slot to set the total number of stepd for the progress bar.
##            
##            @param totalSteps total number of steps for the progress bar
##            """
##            self.bar.setTotalSteps(totalSteps)
##        
##        def setProgress(self, progress):
##            """
##            Public slot to set the current progress of the progress bar.
##            
##            @param progress progress value to set
##            """
##            self.bar.setProgress(progress)

except (ImportError, RuntimeError):
    os.environ["e4nokde"] = "1"

from PyQt4.QtGui import QProgressDialog
class __qtKQProgressDialog(QProgressDialog):
    """
    Compatibility class to use the Qt Progress Dialog.
    """
    pass

################################################################################

from PyQt4.QtCore import Qt

def KQProgressDialog(labelText, cancelButtonText, minimum, maximum, 
                     parent = None, f = Qt.WindowFlags(Qt.Widget)):
    """
    Public function to instantiate a progress dialog object.
    
    @param labelText text to show in the progress dialog (QString)
    @param cancelButtonText text to show for the cancel button or
        None to disallow cancellation and to hide the cancel button (QString)
    @param minimum minimum value for the progress indicator (integer)
    @param maximum maximum value for the progress indicator (integer)
    @param parent reference to the parent widget (QWidget)
    @param f window flags for the dialog (Qt.WindowFlags)
    @return reference to the progress dialog object
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        return __kdeKQProgressDialog(labelText, cancelButtonText, 
                                     minimum, maximum, parent, f)
    else:
        return __qtKQProgressDialog(labelText, cancelButtonText, 
                                    minimum, maximum, parent, f)
