# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Compatibility module to use the KDE Font Dialog instead of the Qt Font Dialog.
"""

import os

import Preferences

try:
    raise ImportError
    # TODO: KDE 4
##    from kdeui import KFontDialog
##    from qt import QFont
##    
##    def __kdeGetFont(initial, parent = None):
##        """
##        Public function to pop up a modal dialog to select a font.
##        
##        @param initial initial font to select (QFont)
##        @param parent parent widget of the dialog (QWidget)
##        @return the selected font or the initial font, if the user
##            canceled the dialog (QFont) and a flag indicating
##            the user selection of the OK button (boolean)
##        """
##        font = QFont(initial)
##        res = KFontDialog.getFont(font, 0, parent)[0]
##        if res == KFontDialog.Accepted:
##            return font, 1
##        else:
##            return initial, 0
    
except (ImportError, RuntimeError):
    os.environ["e4nokde"] = "1"

import PyQt4.QtGui
__qtGetFont = PyQt4.QtGui.QFontDialog.getFont

################################################################################

def getFont(initial, parent = None):
    """
    Public function to pop up a modal dialog to select a font.
    
    @param initial initial font to select (QFont)
    @param parent parent widget of the dialog (QWidget)
    @return the selected font or the initial font, if the user
        canceled the dialog (QFont) and a flag indicating
        the user selection of the OK button (boolean)
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        return __kdeGetFont(initial, parent)
    else:
        return __qtGetFont(initial, parent)
