# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a CPP lexer with some additional methods.
"""

from qtext import QextScintillaLexerCPP
from qt import *

from Lexer import Lexer

class LexerCPP(QextScintillaLexerCPP, Lexer):
    """ 
    Subclass to implement some additional lexer dependant methods.
    """
    def __init__(self, parent=None, name=None):
        """
        Constructor
        
        @param parent parent widget of this lexer
        @param name name of this lexer
        """
        QextScintillaLexerCPP.__init__(self, parent, name)
        Lexer.__init__(self)
        
        self.commentString = QString("//~ ")
        self.streamCommentString = {
            'start' : QString('/* '),
            'end'   : QString(' */')
        }
        self.boxCommentString = {
            'start'  : QString('/* '),
            'middle' : QString(' * '),
            'end'    : QString(' */')
        }
