# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Package implementing compatibility modules for using KDE dialogs instead og Qt dialogs.

The different modules try to import the KDE dialogs and implement interfaces, that are
compatible with the standard Qt dialog APIs. If the import fails, the modules fall back
to the standard Qt dialogs.

In order for this package to work PyKDE must be installed (see 
<a href="http://www.riverbankcomputing.co.uk/pykde">
http://www.riverbankcomputing.co.uk/pykde</a>.
"""

try:
    import os
    if os.getenv("e3nokde"):
        raise ImportError
        
    import kdecore
    import pykdeconfig
    from qt import QString
    
    def isKDE():
        """
        Public function to signal the availability of KDE.
        
        @return availability flag (always 1)
        """
        return 1
        
    def kdeVersionString():
        """
        Public function to return the KDE version as a string.
        
        @return KDE version as a string (QString)
        """
        try:
            from kdecore import KDE
            return KDE.versionString()
        except (ImportError, AttributeError):
            try:
                return QString(pykdeconfig.Configuration().kde_version_str)
            except:
                return QString("unknown")
        
    def pyKdeVersionString():
        """
        Public function to return the PyKDE version as a string.
        
        @return PyKDE version as a string (QString)
        """
        try:
            return QString(pykdeconfig.Configuration().pykde_version_str)
        except:
            return QString("unknown")
    
except (ImportError, RuntimeError):
    
    from qt import QString
    
    def isKDE():
        """
        Public function to signal the availability of KDE.
        
        @return availability flag (always 0)
        """
        return 0
        
    def kdeVersionString():
        """
        Public function to return the KDE version as a string.
        
        @return KDE version as a string (QString) (always empty)
        """
        return QString("")
        
    def pyKdeVersionString():
        """
        Public function to return the PyKDE version as a string.
        
        @return PyKDE version as a string (QString) (always empty)
        """
        return QString("")
