# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Compatibility module to use KApplication instead of QApplication.
"""

try:
    import os
    if os.getenv("e3nokde"):
        raise ImportError
        
    from kdecore import KApplication, KCmdLineArgs, KLocale
    import sys
    import Preferences
    from qt import QTextCodec
    
    def _localeString():
        """
        Protected function to get the string for the configured locale.
        
        @return locale name (string)
        """
        loc = Preferences.getUILanguage()
        if loc is None:
            return "en_US"
    
        if loc == "System":
            loc = unicode(QTextCodec.locale())
        if loc == "C":
            loc = "en_US"
        return loc
        
    class KQApplication(KApplication):
        """
        Compatibility class to use KApplication instead of Qt's QApplication.
        """
        def __init__(self, argv, opts):
            """
            Constructor
            
            @param argv command line arguments
            @param opts acceptable command line options
            """
            KLocale.setMainCatalogue("kdelibs")
            loc = _localeString()
            os.environ["KDE_LANG"] = loc
            sysargv = argv[:]
            try:
                KCmdLineArgs.init(sysargv, sysargv[0], '', '', '')
            except TypeError:
                KCmdLineArgs.init(sysargv, sysargv[0], '', '')
            if opts:
                KCmdLineArgs.addCmdLineOptions(opts)
            KApplication.__init__(self)
    
except (ImportError, RuntimeError):
    from qt import QApplication
    class KQApplication(QApplication):
        """
        Compatibility class to use QApplication.
        """
        def __init__(self, argv, opts):
            """
            Constructor
            
            @param argv command line arguments
            @param opts acceptable command line options (ignored)
            """
            QApplication.__init__(self, argv)
