#ifndef __CSINKINET_H__
#define __CSINKINET_H__

/* csinkinet.h 
 * Author(s): Jim Meier, Cory Stone
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>


#include "csink.h"
#include "csinksocket.h"

#ifndef INADDR_NONE
#define INADDR_NONE     (0)
#endif /* INADDR_NONE */


/* Casting macros */
#define CSINK_INET(sink)		( (CSinkInet*)sink )
#define CSINK_INET_TYPE			0xabcdef


typedef struct _CSinkInet CSinkInet;

#define SOCKET_INET_DNS_INPROGRESS_REMOTE   (1 << 2)
#define SOCKET_INET_DNS_INPROGRESS_LOCAL    (1 << 3)
#define SOCKET_INET_DNS_INPROGRESS  \
  (SOCKET_INET_DNS_INPROGRESS_LOCAL | SOCKET_INET_DNS_INPROGRESS_REMOTE)

typedef struct {
  int active;
  void *fd_watch_tag;
  FILE *fp;
  uint32_t *in_addr_target;
  CSinkCallbackFunc on_lookup;
  CSinkCallbackFunc chain_callback;
  CSinkInet *sink;
} CSinkInetDNSLookup;

struct _CSinkInet {
  CSinkSocket socket;			/* The socket sink. */

  /* Information for filling the socket address in socket (above).
   * These must all be kept in sync! */
  gchar *hostname;		/* Name of remote host. */
  uint32_t ip;		/* IP of remote host. */
  gint port;			/* Port of remote host. */
  CSinkInetDNSLookup *remote_lookup; /* control structure for hostname 
				       resolution */

  gchar *localinterface;	/* which local interface are we using?. */
  uint32_t localip;		/* My IP. */
  int localport;		/* Our port number. */
  CSinkInetDNSLookup *local_lookup; /* control structure for hostname 
				       resolution */


  CSinkCallbackFunc on_dns_lookup_success;
};


/* User-level functions */
CSinkInet * csink_inet_create (CSinkInet * sink); 
void csink_inet_close (CSinkInet * sink); 


/* Set/get remote host/ip. */
void csink_inet_set_remote_host (CSinkInet * sink, const gchar * hostname);
const gchar *csink_inet_get_remote_host (CSinkInet * sink);
int csink_inet_get_remote_host_ip (CSinkInet * sink);
gchar *csink_inet_get_remote_host_quads (CSinkInet * sink);

/* Set/get ports */
void csink_inet_set_local_port (CSinkInet * sink, const gint port);
void csink_inet_set_remote_port (CSinkInet * sink, const gint port);
gint csink_inet_get_remote_port (CSinkInet * sink);
gint csink_inet_get_local_port (CSinkInet * sink);

/* To bind to a specific local interface */
void csink_inet_set_local_interface (CSinkInet * sink, const gchar * hostname);
const gchar *csink_inet_get_local_interface (CSinkInet * sink);



/* Internal functions */
void csink_inet_init (CSinkInet *sink);
void csink_inet_release (CSinkInet *sink);
int csink_inet_listen (CSinkInet * sink);
CSink * csink_inet_do_accept (CSinkInet *sink);
void csink_inet_set_on_dns_lookup_success (CSinkInet *sink,
					   CSinkCallbackFunc cb);

#endif

