/***************************************************************************
                          pointmatch.h  -  description
                             -------------------
    begin                : Tue Jan 6 2003
    copyright            : (C) 2003 by 
    email                : mmdigitizer@earthlink.net
    $Log: pointmatch.h,v $
    Revision 1.3  2005/03/20 01:47:06  markmitch
    After KDevelop 3 restructuring

    Revision 1.8  2004/09/27 04:52:26  markmitch
    KDevelop does not allow renaming source directory to src

    Revision 1.6  2004/09/12 22:29:21  markmitch
    Settings archival complete. Qt2-compatibility code removed

    Revision 1.5  2004/01/14 06:54:38  markmitch
    Point match works well and has documentation

    Revision 1.4  2004/01/13 18:53:33  markmitch
    Point match works but needs bells and whistles

    Revision 1.3  2004/01/13 17:54:06  markmitch
    Testing point match

    Revision 1.2  2004/01/08 06:48:35  markmitch
    Reworked menu icons look great

    Revision 1.1  2004/01/07 07:48:07  markmitch
    Implementing point match


 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef POINTMATCH_H
#define POINTMATCH_H

#include <qimage.h>
#include <qcolor.h>
#include <qpoint.h>
#include <qintdict.h>
#include <qptrlist.h>

#include "digitdef.h"
#include "digitdebug.h"

class Match;

// pointer list that also sorts Match objects by xTheta coordinate
template <class T>
class MatchPtrList: public QPtrList<T>
{
  protected:

    virtual int compareItems(QPtrCollection::Item item1, QPtrCollection::Item item2)
    {
      PointMatchTriplet* p1 = (PointMatchTriplet*) item1;
      PointMatchTriplet* p2 = (PointMatchTriplet*) item2;
      if (p1->correlation > p2->correlation)
        return -1;
      else if (p1->correlation < p2->correlation)
        return 1;
      else
        return 0;
    }
};

// the point lists are pointer lists (versus value lists) so that, for brief
// intervals, there can be multiple pointsets that share the same points. Further
// information can be found in the PointSets comments
typedef MatchPtrList<PointMatchTriplet> PointMatchList;
typedef QPtrListIterator<PointMatchTriplet> PointMatchListIterator;

// this class searches through the original or processed image and 
// isolates candidate match points. the matches are sorted by
// quality of match
class PointMatch
{
  public:
  
    PointMatch();
    ~PointMatch();

    // recursively isolate the "on" pixels around (x,y). return true if pixel at (x,y) was on
    bool isolateSampleMatchPoint(QPointArray* samplePointPixels,
      const QImage &image, PointMatchSettings settings,
      int xStart, int yStart, int x, int y);

    // create document points that match the sample point under the cursor
    void matchSamplePoint(const QImage &imageProcessed,
      PointMatchSettings settings, const QPointArray &samplePointPixels,
      const QPointArray &pointsExisting, QValueList<PointMatchTriplet>* pointsCreated);
  
  private:

    enum PixelStates
    {
      PixelOff,
      PixelOnUnscanned,
      PixelOnScanned
    };
    
    // create mask array from sample point
    void convertSampleToArray(const QPointArray &samplePointPixels,
      bool** sampleMaskArray, int* sampleMaskWidth, int* sampleMaskHeight,
      int* xCenter, int* yCenter);

    // create image array from processed image
    void convertImageToArray(const QImage &imageProcessed, int** imageArray,
      int* imageWidth, int* imageHeight);

    // correlate sample and image around specified screen location
    bool correlation(bool* sampleMaskArray,
      int sampleMaskWidth, int sampleMaskHeight,
      int sampleXCenter, int sampleYCenter,
      int* imageArray,
      int imageWidth, int imageHeight, int x, int y, double* corr);
  
    // prevent duplication of existing points. this function returns
    // the number of pixels removed
    void removePixelsNearCurrentPoints(int* imageArray, int imageWidth, int imageHeight,
      const QPointArray &pointsExisting, int pointSeparation);

    // search through contiguous on-pixels in this region
    void recurseThroughOnRegion(bool* sampleMaskArray,
      int sampleMaskWidth, int sampleMaskHeight,
      int sampleXCenter, int sampleYCenter,
      int* imageArray, int imageWidth, int imageHeight, int x, int y,
      bool* firstMax, int*onCount, int* xSum, int* ySum,
      int* xMin, int* xMax, int* yMin, int* yMax,
      double* correlationMax);

    // correlate the sample point with the image, returning points in list that is
    // sorted by correlation
    void scanImage(bool* sampleMaskArray,
      int sampleMaskWidth, int sampleMaskHeight,
      int sampleXCenter, int sampleYCenter, PointMatchSettings settings,
      int* imageArray, int imageWidth, int imageHeight,
      PointMatchList* pointsCreated);
};

#endif // POINTMATCH_H
