/***************************************************************************
                          matchset.h  -  description
                             -------------------
    begin                : Mon Jan 12 2004
    copyright            : (C) 2004 by 
    email                : mmdigitizer@earthlink.net
    $Log: matchset.h,v $
    Revision 1.3  2005/03/20 01:47:05  markmitch
    After KDevelop 3 restructuring

    Revision 1.7  2004/09/27 04:52:26  markmitch
    KDevelop does not allow renaming source directory to src

    Revision 1.5  2004/09/12 22:29:21  markmitch
    Settings archival complete. Qt2-compatibility code removed

    Revision 1.4  2004/01/19 17:56:32  markmitch
    Combobox focus. Point match style. Empty accepted list

    Revision 1.3  2004/01/14 06:54:38  markmitch
    Point match works well and has documentation

    Revision 1.2  2004/01/13 18:53:33  markmitch
    Point match works but needs bells and whistles

    Revision 1.1  2004/01/13 17:54:06  markmitch
    Testing point match


 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MATCHSET_H
#define MATCHSET_H

#include <qcanvas.h>
#include <qtextstream.h>
#include <qptrlist.h>

#include "digitdef.h"

class Match;

// this class contains all Match class objects, and parallels the
// PointSet class, although this is much more simple. the Match
// objects owned by this class were originally owned by a QArray,
// but that created dependency problems in the header file
class MatchSet
{
  public:

    MatchSet();
    ~MatchSet();

    // return currently accepted points
    void acceptedPoints(QValueList<QPoint>* acceptedPoints);
    
    // create one canvas item for each matched point
    void addCreatedPointsToCanvas(QCanvas* canvas, PointSetStyle style,
      PointMatchSettings settings, const QValueList<PointMatchTriplet>* pointsCreated,
      QValueList<QRect>* updateRectList);

    // destroy all objects, releasing allocated memory
    void clear(QValueList<QRect>* updateRectList);

    // accept or reject one point, return true if a point's state was changed
    bool matchPointAccept(QValueList<QRect>* updateRectList);
    bool matchPointReject(QValueList<QRect>* updateRectList);

    // show style change on screen
    void setPointSetStyle(PointSetStyle style);
    
  private:

    // highlight maintenance
    QCanvasRectangle* makeHighlight(Color color);
    void moveHighlights(QValueList<QRect>* updateRectList);

    QCanvas* m_canvas;
    PointMatchSettings m_settings;

    // pointer list of Match objects. QArray might have been better, but QArray
    // requires default constructors for its objects, but QCanvasItems require
    // pointer to canvas in all of the constructors. speed is not much of an issue
    // since only one search is performed after each keypress speed
    int m_matches;
    QPtrList<Match> m_matchList;

    // highlight the two points that could change state. QCanvasEllipse is not an
    // option since the pen is always NoPen
    QCanvasRectangle* m_highlightAccepted;
    QCanvasRectangle* m_highlightRejected;
};

#endif // MATCHSET_H
