/*
	         Endeavour MIME Types List & Edit Window
 */

#ifndef MIMETYPESWIN_H
#define MIMETYPESWIN_H

#include <gtk/gtk.h>

#include "edvtypes.h"
#include "edvmimetypes.h"
#include "editclist.h"


typedef struct _edv_mimetype_listwin_struct	edv_mimetype_listwin_struct;
typedef struct _edv_mimetype_editwin_struct	edv_mimetype_editwin_struct;
typedef struct _edv_mimetype_icon_picker_struct	edv_mimetype_icon_picker_struct;


/*
 *	MIME Type Edit Window Icon Picker:
 */
struct _edv_mimetype_icon_picker_struct {

	edv_mimetype_editwin_struct *editwin;

	GtkWidget	*toplevel,	/* GtkBox */
			*button,	/* Icon GtkButton */
			*gtk_pixmap,
			*left_btn, *right_btn, *state_label;

	GtkAdjustment	*adj;		/* Icon state GtkAdjustment */

	gint		icon_width,	/* Requested icon size */
			icon_height;

	GdkPixmap	*pixmap[EDV_MIMETYPE_TOTAL_ICON_STATES];
	GdkBitmap	*mask[EDV_MIMETYPE_TOTAL_ICON_STATES];

	gchar		*path[EDV_MIMETYPE_TOTAL_ICON_STATES];

};
#define EDV_MIMETYPE_ICON_PICKER(p)	((edv_mimetype_icon_picker_struct *)(p))

/*
 *      MIME Type Edit Window:
 */
struct _edv_mimetype_editwin_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	gpointer	core_ptr;

	edv_mimetype_listwin_struct	*listwin;

	gboolean	has_changes;
	gchar		*title;

	GtkWidget       *main_vbox,
			*class_combo,
			*type_entry,
			*value_label,
			*value_entry,
			*description_entry,
			*handler_combo,
			*ok_btn,
			*apply_btn,
			*cancel_btn,
			*close_btn;

	gint		mt_num;		/* MIME Type being edited */

	editclist_struct	*editclist;

	/* Icon Pickers */
	edv_mimetype_icon_picker_struct	*icon_small,
					*icon_medium,
					*icon_large;

};
#define EDV_MIMETYPE_EDITWIN(p)	((edv_mimetype_editwin_struct *)(p))

/*
 *	MIME Type List Window:
 */
struct _edv_mimetype_listwin_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	gpointer	core_ptr;

	GtkWidget	*main_vbox,
			*find_entry,
			*mimetypes_clist,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*up_btn,
			*down_btn,
			*save_btn,
			*import_btn,
			*export_btn,
			*display_parent,	/* GtkVBox */
			*display_client,
			*display_icon,
			*display_edit_btn,
			*close_btn;

	/* Right click menu */
	GtkWidget	*menu,
			*add_mi,
			*edit_mi,
			*remove_mi,
			*up_mi,
			*down_mi,
			*save_mi,
			*import_mi,
			*export_mi;

	edv_mimetype_editwin_struct	*editwin;

	/* Pixmap and mask pairs for class icons */
	GdkPixmap	*system_object_pixmap;
	GdkBitmap	*system_object_mask;
	GdkPixmap	*file_format_pixmap;
	GdkBitmap	*file_format_mask;
	GdkPixmap	*program_pixmap;
	GdkBitmap	*program_mask;
	GdkPixmap	*unique_object_pixmap;
	GdkBitmap	*unique_object_mask;

};
#define EDV_MIMETYPE_LISTWIN(p)	((edv_mimetype_listwin_struct *)(p))


/* In mimetypesedit.c */
extern void EDVMimeTypesEditWinFetchValues(
	edv_mimetype_editwin_struct *ew, gint mt_num
);
extern void EDVMimeTypesEditWinMimeTypeRemovedCB(
	edv_mimetype_editwin_struct *ew, gint mt_num
);

extern edv_mimetype_editwin_struct *EDVMimeTypesEditWinNew(
	gpointer core_ptr, gpointer listwin
);
extern void EDVMimeTypesEditWinResetHasChanges(
	edv_mimetype_editwin_struct *ew, gboolean has_changes
);
extern void EDVMimeTypesEditWinUpdateMenus(edv_mimetype_editwin_struct *ew);
extern gboolean EDVMimeTypesEditWinIsMapped(edv_mimetype_editwin_struct *ew);
extern void EDVMimeTypesEditWinMap(edv_mimetype_editwin_struct *ew);
extern void EDVMimeTypesEditWinUnmap(edv_mimetype_editwin_struct *ew);
extern void EDVMimeTypesEditWinDelete(edv_mimetype_editwin_struct *ew);


/* In mimetypeswin.c */
extern void EDVMimeTypesListWinSelect(
	edv_mimetype_listwin_struct *lw, gint i
);
extern gint EDVMimeTypesListWinSelectByType(
	edv_mimetype_listwin_struct *lw, const gchar *type
);

extern void EDVMimeTypesListWinSetRow(
	edv_mimetype_listwin_struct *lw, gint row, edv_mimetype_struct *mt_ptr
);
extern void EDVMimeTypesListWinFetchValues(
	edv_mimetype_listwin_struct *lw
);

extern void EDVMimeTypesListWinReconfiguredNotifyCB(
	edv_mimetype_listwin_struct *lw
);

extern void EDVMimeTypesListWinMimeTypeAddedCB(
	edv_mimetype_listwin_struct *lw,
	gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVMimeTypesListWinMimeTypeModifiedCB(
	edv_mimetype_listwin_struct *lw,
	gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVMimeTypesListWinMimeTypeRemovedCB(
	edv_mimetype_listwin_struct *lw,
	gint mt_num
);

extern edv_mimetype_listwin_struct *EDVMimeTypesListWinNew(
	gpointer core_ptr
);
extern void EDVMimeTypesListWinUpdateMenus(edv_mimetype_listwin_struct *lw);
extern void EDVMimeTypesListWinSetBusy(
	edv_mimetype_listwin_struct *lw, gboolean is_busy
);
extern gboolean EDVMimeTypesListWinIsMapped(edv_mimetype_listwin_struct *lw);
extern void EDVMimeTypesListWinMap(edv_mimetype_listwin_struct *lw);
extern void EDVMimeTypesListWinUnmap(edv_mimetype_listwin_struct *lw);
extern void EDVMimeTypesListWinDelete(edv_mimetype_listwin_struct *lw);


#endif	/* MIMETYPESWIN_H */
