/*
 * The Satellite Image files are great for VGA 4-bit per pixel display.
 *
 * In the unix environment, all we really need is a conversion to the
 * pgm format for use by any other image viewer (netscape, xv, ....).
 *
 * This program is a filter, i.e. it takes its input on stdin and output
 * goes to stdout.
 */
#include <stdio.h>
#include <stdlib.h>

int
main(int argc,char *argv[])
{
  FILE *infile;
  char comment[37];
  unsigned char *data;
  int ch, i, plane, bit;
  char out;

  if (argc>1) {
    infile=fopen(argv[1],"r");
    if (infile==NULL) {
      printf("Usage:\n\t%s infile > outfile.pgm\n",argv[0]);
      printf("where infile is a .CC1 image format file.\n");
      printf("Or,\n\tcat infile | %s > outfile.pgm \n",argv[0]);
      printf("Or,\n\tcat infile | %s | xv - \n",argv[0]);
      printf("File format information is at\n");
      printf(" http://www.nws.noaa.gov/oso/oso1/oso12/document/winnet.htm\n");
      printf("and files might be found at\n");
      printf(" ftp://iwin.nws.noaa.gov/\n");
      return(1);
    }
  } else {
    infile = stdin;
  }

  for (i=0;i<36;i++) {
    if(EOF==(ch=getc(infile))) {
      fprintf(stderr,"%s: Bad input\n",argv[0]);
      return(1);
    }
    comment[i]=ch;
  }
  comment[36]=0;
  data = (unsigned char *)malloc(4*38400);
  for (plane=0;plane<4;plane++)
    for (i=0;i<38400;i++) {
      if(EOF==(ch=getc(infile))) {
	fprintf(stderr,"%s: Bad input\n",argv[0]);
	return(1);
      }
      data[plane*38400+i] = ch;
    }

  printf("P5\n");
  printf("# %s\n",comment);
  printf("640 480\n16\n");

  for (i=0;i<38400;i++)
    for (bit=7;bit>=0;bit--) {
      out=0;
      for (plane=0;plane<4;plane++)
	out += ((data[plane*38400+i]&(1<<bit))?0:1)<<plane;
      printf("%c",15-out);
    }
 

  free(data);
  return(0);
}
