/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "fortint.h"

/*
// FORTRAN callable chmod:
//
//   INTEGER FUNCTION JCHMOD (NAME, MODE)
//   CHARACTER*(*) NAME, MODE
//
//   The normal returned value is 0.  Any other value will be a system error
//   number.
//
*/

fortint jchmod_(char * filename, char * char_mode, long l1, long l2)
{
mode_t mode = 0;
int i, status = 0;
char * name;

    if( (*char_mode) == '0' )
    {
      for( i = 0; i < l2; i++)
        mode = (mode*8) + (*(char_mode+i)-'0');
    }
    else
    {
      for( i = 0; i < l2; i++)
        mode = (mode*10) + (*(char_mode+i)-'0');
    }

    name = (char*) malloc(l1+1);
    for( i = 0; i < l1; i++)
      name[i] = filename[i];
    name[l1] = '\0';

    status = chmod(name, mode);
    if( status ) {
      perror("JCHMOD error");
      exit(1);
    }

    free(name);

    return (fortint) status;
}

fortint jchmod(char * filename, char * char_mode, long l1, long l2) {
  return jchmod_(filename,char_mode,l1,l2);
}
