<?php

#  Copyright (C) 2008 Neil Williams <codehelp@debian.org>
#
#  This package is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

# A few notes:
# 1. The CSS from buildd.debian.org is embedded so the colours match
# 2. There are ONLY two files / data sources available to this script -
#    the em_autobuild log and the emtarget file. (It is meant to be 
#    usable on the buildd as well as on www.emdebian.org.)
# 3. The script currently assumes /var/www


if (is_file ("/var/www/toolchains/emdebian.php"))
{
	include_once "/var/www/toolchains/emdebian.php";
	emheader();
}
?>
<style type="text/css">
a:visited {
	color: #3030ff;
	text-decoration: none;
}

a:link    {
	color: #3030ff;
	text-decoration: none;
}

a:hover {
    text-decoration: underline;
}

/* data table */

.data {
    border-collapse: collapse;
    border: 1px solid #999999;
    font-size: 90%;
    margin: 1em 0em 1em 0em;
}

table.data th.title {
    background: #fffff1;
    border: 1px solid #999999;
    color: #333333;
    font-weight: bold;
    font-size: 120%;
    padding: 0.5em 1em 0.5em 1em;
    white-space: nowrap;
}

.data th {
    background: #ffffcc;
    border: 1px solid #999999;
    font-weight: bold;
    color: #545325;
    padding: 0em 0.2em 0em 0.2em;
}

.data td {
    border: 1px solid #999999;
    padding: 0.1em 0.5em;
    text-align: left;
    vertical-align: top;
}

.data tr.odd {
  background: #f9f9f1;
}

.data td.crit {
  background: #c15757;
}

.data td.warn {
  background: #cfcf00;
}

.data td.good {
  background: #00ff00;
}

.data tr.even {
  background: #ffffff;
}

.data tr:hover { background: #f4f4f4; }
</style>
<h1 style="position:absolute;top:10px;left:350px;font-family:sans-serif;">
Package History</h1>
<p>The package name in the table links to the repository data for the
package.
</p>
<?php
if ($_GET['pkg'] != '')
{
	# needs support for ARCH in the query string too.
	$pkg = htmlspecialchars ($_GET['pkg']);
	$pkg = preg_replace ('/\.+\/+/', "", $pkg);
	$pkg = preg_replace ('/\//', "", $pkg);
	$files = array ();
	print "<h2>Package: $pkg</h2>";
	print "<a href=\"index.php?log=#$pkg\">Back</a><br/>\n";
	$initchar = $pkg[0];
	$dirlist = array ();
	$pkglist = array ();
		if ($builddh = opendir ("/var/www/buildd/$initchar/$pkg/trunk/"))
	{
		while (($logfile = readdir ($builddh)) != false)
		{
			if (filetype ("$initchar/$pkg/trunk/". $logfile) != "dir")
			{
				preg_match ("/-([^-]*)-([0-9]+)\.log$/", $logfile, $matches);
				$arch = $matches[1];
				$time = $matches[2];
				array_push ($files, $logfile);
				$last_log++;
			}
		}
	}
	print "<h3>$last_log buildd logs</h3>";
	rsort ($files);
?>

<table class="data">
<tr><th>Package</th><th>Architecture</th><th>Version</th>
<th>Latest Build Time</th>
<th>Latest Build State</th>
<th>Possible reasons</th>
</tr>
<?php
	foreach ($files as $file)
	{
		$status=0;
		preg_match ("/(.*)-([^-]*)-([0-9]+)\.log$/", $file, $matches);
		$pkg = $matches[1];
		$arch = $matches[2];
		$time = $matches[3];
		$timestr = date ("D jS M, H:i:s T", $time);
		print "<tr id=\"$pkg\">\n";
		print "<td><a href=\"";
		print "http://www.emdebian.org/packages/search.php?package=$pkg\">";
		print "$pkg</a></td>";
		print "<td>".$arch."</td>";
#		print "<td>".$timestr."</td>";
	$contents = file_get_contents ("$initchar/$pkg/trunk/$file");
	if (preg_match ("#Changes file: /.*/$initchar/$pkg/trunk/${pkg}_(.*)_$arch.changes#", $contents))
	{
		preg_match ("#Changes file: /.*/$initchar/$pkg/trunk/${pkg}_(.*)_$arch.changes#", $contents, $matches);
		print "<td>".$matches[1]."</td>";
	}
	else
	{
		if (preg_match ("/dpkg-buildpackage: source version (.*)/", $contents, $matches))
		{
			print "<td>".$matches[1]."</td>";
		}
		# special tag line added by emsource >= 1.1.6 to assist in version detection.
		else if (preg_match ("/emsource: Attempted version: (.*)/", $contents, $matches))
		{
			print "<td>".$matches[1]."</td>";
		}
		else
		{
			print "<td>&nbsp;</td>";
		}
	}
	$safefile=urlencode($file);
	$safepkg=urlencode($pkg);
	print "<td>".$timestr."</td>";
	if (preg_match ("/dpkg-buildpackage: failure/", $contents)
		|| (! preg_match("/dpkg-genchanges/", $contents))
		|| (! preg_match("/Successful build/", $contents)))
	{
		print "<td class=\"warn\">";
		print "<a href=\"index.php?log=$safefile&amp;pkg=$safepkg\">maybe failed</a>";
		print "</td>\n";
		$status = -1;
		$numfail++;
	}
	else
	{
		print "<td class=\"good\">";
		print "<a href=\"index.php?log=$safefile&amp;pkg=$safepkg\">maybe successful</a>";
		print "</td>\n";
		$status = 1;
		$numok++;
	}
	# Look for the messages put into the build log by embug.
	$fail_pat = "Recording that the package failed to build.";
	$patch_pat = "Recording that the Emdebian SVN patches are out of date for";
	$lintian_pat = "Recording that '.*' has failed a lintian check";
	$fail_patch = "Package failed to build but patches are marked as out of date.";
	$wait_pat = "Recording that .* is waiting for another dependency.";
	# span support for each error.
	$ok="<td class=\"good\">";
	$bad="<td class=\"warn\">";
	if (preg_match("/$patch_pat/", $contents))
	{
		print $bad."Patches failed to apply.</td>\n";
	}
	else if (preg_match("/$fail_pat/", $contents))
	{
		print $bad."Failed to cross-build.</td>\n";
	}
	else if (preg_match("/$fail_patch/", $contents))
	{
		print $bad."Patches out of date.</td>\n";
	}
	else if (preg_match("/$lintian_pat/", $contents))
	{
		print $bad."Lintian errors.</td>\n";
	}
	else if ($status > 0)
	{
		# once uploads are automated, append .upload to log
		# and look for that data here.
		$dput_pat = "Successfully uploaded ?.* ?to ";
		if (preg_match("/$dput_pat/", $contents))
		{
			print $ok."Installed.</td>\n";
		}
		else if (preg_match("/$wait_pat/", $contents))
		{
			print $ok."Possible dependency problem.</td>\n";
		}
		else
		{
			print $ok."Manual upload.</td>\n";
		}
	}
	else
	{
		print "<td>&nbsp;</td>\n";
	}
	print "</tr>\n";
}

?>
</table>
</td>
    </tr>
</table>
<?php
if ($numok > 0)
{
	print "<p>$numok successful builds.</p>";
}
if ($numfail > 0)
{
	print "<p>$numfail failed cross builds.</p>";
}
?>
<p><a href="<?php echo "$SELF"; ?>?log=#top">Top</a>.</p>
<?php
	}
?>

<div style="clear: both;">&nbsp;</div>
<p>The autobuilder is part of <a 
href="http://packages.qa.debian.org/e/emdebian-tools.html">emdebian-tools</a>.
</p>
<?php
if (is_file ("/var/www/toolchains/emdebian.php"))
{
	footer();
}
?>
