#ifndef __CMD_H__
#define __CMD_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2002, 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "ecurses.h"
#include "keymap.h"
#include "hook.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/

typedef enum {CMD_INVALID,
              CMD_LIST,
              CMD_READ_MAIL,
              CMD_SELECT_BOX,
              CMD_FETCH,
              CMD_SENDER,
              CMD_ATTACH,
              CMD_ABOOK,
              CMD_ABOOK_ADD,
              CMD_ASK,
              CMD_HELP,
              CMD_READ,
              CMD_DEBUG,
              CMD_SEARCH,
} cmd_state_t;

#define CMD_STATE_COUNT (CMD_SEARCH + 1)

#ifndef GNUC
# define __attribute__(a)
#endif

/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/

extern WINDOW  *cmd_win;

extern keymap_t keymaps[];

/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern void cmd_add_readfd_handler (int fd, void (*handler)(int));
extern void cmd_add_writefd_handler (int fd, void (*handler)(int));
extern void cmd_add_timeout_handler (void (*handler)(int));
extern void cmd_del_readfd_handler (int fd);
extern void cmd_del_writefd_handler (int fd);

extern void cmd_text_color (void);
extern void cmd_error_color (void);

extern void        cmd_init (void);
/** quit elmo */
extern void        cmd_quit (void);
/*+
  Particularly useful, when you want to disable a key.
  +*/
/** do noting */
extern void        cmd_nothing (void);
/*+
  Particularly useful, when you want to perform some actions
  at the very beginning.  This function is executed only once
  during the program execution.
  +*/
/** executed right after startup */
extern void        cmd_after_startup (void);
extern void        cmd_read_loop (void) __attribute__ ((noreturn));
extern void        cmd_state_push (cmd_state_t requested_state);
extern int         cmd_state_pop (void);
extern cmd_state_t cmd_state_get (int from_top);
extern void        cmd_choose (void);
extern int         cmd_last_char (void);
extern int         cmd_prefix_arg (void);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER cmd.h
 *
 ****************************************************************************/
#endif
