#!/usr/bin/env perl
#
#  elmo - ELectronic Mail Operator
#
#  Copyright (C) 2003 rzyjontko
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; version 2.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

use strict;
use warnings;

my ($comment, $long, $in_long);

$comment = "";
$long    = "";
$in_long = 0;
while (<STDIN>){
    
    if ($in_long){
	if (/\+\*\//){
	    $in_long = 0;
	}
	else {
	    $long = $long . $_;
	}
    }
    else {
	
	if (/\/\*\+/){
	    $long    = "";
	    $in_long = 1;
	}
	
	if (/\/\*\*\ +([^\*]*[^ \t])[ \t]*\*\//){
	    $comment = $1;
	}
	elsif (/\/\*\!\ +([^\*]*[^ \t])[ \t]*\*\//){
	    $comment = $1;
	}
	elsif (/\/\/\/\ +(.*[^ \t])[ \t]*\n/){
	    $comment = $1;
	}
	elsif (/extern\ void\ +([a-zA-Z_0-9]+)\ *\(void\);/
	       && ! /.*free_resources/){
	    if ($comment eq ""){

	    }
	    else {
		if (! $long eq ""){
		    print "/*\n$long */\n";
		    $long = "";
		}
		print "{\"$1\", $1, NULL, \"$comment\"},\n";
		$comment = "";
	    }
	}
	else {
	    $comment = "";
	}
    }
}
