# Elisa - Home multimedia server
# Copyright (C) 2006 Fluendo, S.A. (www.fluendo.com).
# All rights reserved.
# 
# This software is available under three license agreements.
# 
# There are various plugins and extra modules for Elisa licensed
# under the MIT license. For instance our upnp module uses this license.
# 
# The core of Elisa is licensed under GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special 
# exception to use Elisa with Fluendo's plugins.
# 
# The GPL part is also available under a commerical licensing
# agreement.
# 
# The second license is the Elisa Commercial License Agreement.
# This license agreement is available to licensees holding valid
# Elisa Commercial Agreement licenses.
# See "LICENSE.Elisa" in the root of this distribution.

import sys
import os, platform

# workaround to run the setup.py from ../elisa-core
curdir = os.getcwd()
if os.path.basename(curdir) != 'elisa-core' and os.path.isdir('elisa-core'):
    os.chdir('elisa-core')

if platform.system() == 'Windows' and os.environ.has_key('ELISA_DEPS'):
    # load the developement environement for windows
    from mswin32 import win_set_env

from elisa.core import __version__, log
from elisa.core.utils.dist import CMD_CLASS, PACKAGE_DATA

from setuptools import find_packages

try:
    import py2exe
except:
    pass

log.init()


# BEGIN MONKEY-PATCH
# we revert to distutils to install our script, we don't want
# generated scripts yet
from distutils.command import install_scripts
from setuptools.command import easy_install as orig_easy_install
import setuptools.command

class easy_install(orig_easy_install.easy_install):
    def install_egg_scripts(self, dist):
        cmd = install_scripts.install_scripts(self.distribution)
        cmd.finalize_options()
        cmd.force = 1
        cmd.run()

orig_easy_install.easy_install = easy_install
# END MONKEY-PATCH

PACKAGE_DATA[''].append('*.svg')

data_files = []
py_exe_options = {}

if platform.system() == 'Linux':
    data_files.extend([('share/pixmaps', [os.path.abspath('data/elisa.png')]),
                       ('share/man/man1', ['docs/elisa.1']),
                       ('share/applications', ['data/elisa.desktop']),
                       ('share/mobile-basic-flash/icons', ['data/elisa.png']),
                       ('share/mobile-basic-flash/applications',
                        ['data/elisa.desktop']),
                       ('share/dbus-1/services',
                       ['data/com.fluendo.elisa.service'])])

elif platform.system() == 'Windows':
    module_include = ['tarfile', 'md5']
    package_include = ['distutils']
    module_exclude = ['gst', 'pygst', 'elisa', 'twisted', 'pgm', 'gtk',
                      'gobject']
    dll_exclude = ['libglade-2.0-0.dll']

    py_exe_options = {"custom_boot_script" : 'mswin32/win_set_env.py', 
                      "includes"           : module_include, 
                      "packages"           : package_include, 
                      "excludes"           : module_exclude,
                      "dll_excludes"       : dll_exclude
                      }

options = dict(cmdclass=CMD_CLASS,
               data_files=data_files,
               name="elisa",
               elisa_infos={'plugin_name': 'core'},
               console=['mswin32/elisa.py'],
               options = {"py2exe": py_exe_options},
               version=__version__,
               description="""Fluendo Media Center""",
               author="The Elisa Team",
               author_email="",
               maintainer="Philippe Normand",
               maintainer_email="philippe@fluendo.com",
               long_description="""\
Elisa is an open media center system to watch, listen, manage and
share videos, files and music. It uses GStreamer, Python and OpenGL
technologies. """,
               url="http://elisa.fluendo.com",
               keywords=['multimedia', 'gstreamer', 'opengl'],
               classifiers = ['Development Status :: 3 - Alpha',
                              'Environment :: X11 Applications',
                              'Intended Audience :: End Users/Desktop',
                     'Natural Language :: English',
                     'Operating System :: OS Independent',
                     'Programming Language :: Python',
                     'Topic :: Multimedia :: Graphics :: 3D Rendering',
                     'Topic :: Multimedia :: Sound/Audio',
                     'Topic :: Multimedia :: Video',
                     ],
               test_suite = ['elisa',],
               zip_safe = False,
               packages=find_packages(exclude=('mswin32*',)),
               namespace_packages=['elisa',],
               py_modules = ['generic_setup', 'elisa_plugin_core_setup',
                             'elisa_boot','elisa_get'],
               scripts = ['scripts/elisa-get','scripts/elisa'],
               include_package_data = True,
               package_data = PACKAGE_DATA,
               entry_points={
                             'distutils.commands':
                             ['build_po = elisa.core.utils.dist:build_po',
                              'bdist_elisa = elisa.core.utils.dist:bdist_elisa'],
                             'distutils.setup_keywords':
                             ['elisa_infos = elisa.core.utils.dist:assert_dict_or_none',],
                             'egg_info.writers':
                             ['elisa_infos.txt = elisa.core.utils.dist:write_dict',]}
               )
