# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

__maintainer__ = 'Florian Boucault <florian@fluendo.com>'

from elisa.core import common
from pgm.widgets.list_ng import List
from pgm.widgets import const

plugin_registry = common.application.plugin_registry
SlideshowView = plugin_registry.get_component_class('slideshow:slideshow_view')

class TranslatingSlideshowView(SlideshowView, List):

    def __init__(self):
        super(TranslatingSlideshowView, self).__init__()
        self.orientation = const.HORIZONTAL

    def do_drag_begin(self, x, y, z, button, time):
        if self.controller.model is None or not self.controller.focused:
            return False
        
        return super(SlideshowView, self).do_drag_begin(x, y, z, button, time)

    def do_drag_motion(self, x, y, z, button, time):
        if self.controller.model is None or not self.controller.focused:
            return False

        return super(SlideshowView, self).do_drag_motion(x, y, z, button, time)
    
    def do_drag_end(self, x, y, z, button, time):
        if self.controller.model is None or not self.controller.focused:
            return False

        return super(SlideshowView, self).do_drag_end(x, y, z, button, time)

    def do_clicked(self, x, y, z, button, time):
        if self.controller.model is None or not self.controller.focused:
            return False

        return super(SlideshowView, self).do_clicked(x, y, z, button, time)
