# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import pgm
from pgm.graph.text import Text

from progressbar_osd import ProgressBarOsd
from dock import Dock


class SlideshowOsd(Dock):

    def __init__(self):
        super(SlideshowOsd, self).__init__()

        self._time_position = 0
        self._time_string = ""

        # FIXME: temporary
        width = 1.0
        height = 1.0

        inner_width = width * 0.9
        inner_x = (width - inner_width)/2.0

        # build the title
        self._title = Text()
        self._title.label = ""
        self._title.ellipsize = pgm.TEXT_ELLIPSIZE_MIDDLE
        self._title.fg_color = (220, 220, 220, 255)
        self._title.bg_color = (0, 0, 0, 0)
        self.add(self._title)
        self._title.position = (inner_x, 0.05, 0.0)
        self._title.size = (inner_width, height*0.33)
        self._title.visible = True

        # build the time bar
        self.progressbar = ProgressBarOsd()
        self.add(self.progressbar)
        self.progressbar.bg_color = (0, 0, 0, 0)
        self.progressbar.position = (inner_x, height*(0.33+0.10), 10.0)
        self.progressbar.size = (inner_width, height*0.2)
        self.progressbar.visible = True

        # build the total time text
        self._time = Text()
        self._time.label = ""
        self._time.fg_color = (255, 255, 255, 255)
        self._time.bg_color = (0, 0, 0, 0)
        self._time.alignment = pgm.TEXT_ALIGN_RIGHT
        self.add(self._time)
        self._time.position = (inner_x, height*(0.33+0.2+0.15), 0.001)
        self._time.size = (inner_width, height*0.2)
        self._time.visible = True

    def length__set(self, length):
        self.progressbar.length = length
        if length > 1:
            self.progressbar.visible = True
            self._show_position()
        else:
            self.progressbar.visible = False

    def length__get(self):
        return self.progressbar.length

    def title__set(self, title):
        self._title.label = title

    def title__get(self):
        return self._title.label

    def index__set(self, position):
        self._time_position = position
        self.progressbar.jump_to_position(position)
        self._show_position()

    def index__get(self):
        return self._time_position

    def _show_position(self):
        self._time.label = "%s / %s" % (self.index, self.length)
