/* $Id: Syntax.c,v 1.3 2000/07/17 15:29:24 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "envmod.h"
#include "ProdElemList.h"
#include "DynSpace.h"
#include "IntSet.h"
#include "pdl_gen.h"
#include "deftbl.h"
#include "Names.h"
#include "GlobKind.h"
#include "msgtxt.h"
#include "Syntax.h"

#include "csm.h"
#include "idn.h"
#ifndef StringRef
#define StringRef(s)    (strng[s])
#endif


static void* ProdSpace;

void InitSyntax ()
{
ProdSpace = InitDynSpace ();
}/* InitSyntax */

ProdElem MakeProdElem (SymbKind, Id, SyntKey, SyntPos, Coord)
	int		SymbKind, Id, SyntPos;
	DefTableKey	SyntKey;
	POSITION *	Coord;
{	ProdElem	res;
res = (ProdElem) DynAlloc (ProdSpace, sizeof (_PElem));
res->SymbKind = SymbKind;
res->Id = Id;
res->Key = SyntKey;
res->SyntPos = SyntPos;
res->Coord = Coord;
return (res);
}/*MakeProdElem*/

int EqualProdElem (e1, e2)
	ProdElem	e1, e2;
{
if ((e1->SymbKind == IsLiteral) && (e2->SymbKind == IsLiteral))
	return (strcmp (StringRef (e1->Id), StringRef (e2->Id)));
else	return (((e1->SymbKind == e2->SymbKind) && (e1->Id == e2->Id))? 0 : 1);
}/* EqualProdElem */

int DifferentProds (p1, p2)
	ProdElemList		p1, p2;
{ return ((CompProdElemList (p1, p2, EqualProdElem)) != 0);
}/*DifferentProds*/

static DefTableKey rulechain = NoKey;

void LinkRule (rulekey)
        DefTableKey     rulekey;
{
SetNextRule (rulekey, rulechain, rulechain);
rulechain = rulekey;
}/* LinkRule */

DefTableKey FindEqualProd (prdkind, rulekey, prod)
	int		prdkind;
	DefTableKey	rulekey;
	ProdElemList		prod;
{	ProdElemList		ruleprod;
while (rulekey != NoKey) {
	if (InIS (prdkind, GetPrdKindSet (rulekey, NullIS()))) {
		ruleprod = GetProd (rulekey, NULLProdElemList);
		if (! (DifferentProds (prod, ruleprod)))
			return (rulekey);
	}
	rulekey = GetNextRule (rulekey, NoKey);
}
return (NoKey);
}/* FindEqualProd */

DefTableKey FindNamedProd (prdkind, prod, env, coord)
	int		prdkind;
	ProdElemList		prod;
	Environment	env;
	POSITION *	coord;
{	DefTableKey	res;

res = FindEqualProd (prdkind, rulechain, prod);
if (res == NoKey) {
	int newid = GenerateName ("rule_");
	res = DefineIdn (env, newid);
	SetSym (res, newid, newid);
	SetCoord (res, coord, coord);
	SetKindSet (res, SingleIS (RuleDef), SingleIS (RuleDef));
	SetPrdKindSet (res, SingleIS (prdkind), SingleIS (prdkind));
	SetProd (res, prod, prod);
	LinkRule (res);
} else {
	POSITION *prevcoord = GetCoord (res, NoPosition);
	DefTableKey next = GetNextRule (res, NoKey);
	next = FindEqualProd (prdkind, next, prod);
	if (next != NoKey) {
		message (ERROR, MSGTXT("unnamed rule refers to several named rules",
				       (lidoref)Rule Specifications),
				0, coord);
		while (next != NoKey) {
			message (ERROR, MSGTXT("named rule refers to unnamed rule",
					       (lidoref)Rule Specifications),
				0, prevcoord);
			prevcoord = GetCoord (next, prevcoord);
			next = GetNextRule (next, NoKey);
			next = FindEqualProd (prdkind, next, prod);
		}
		message (ERROR, MSGTXT("named rule refers to unnamed rule",
				       (lidoref)Rule Specifications),
			0, prevcoord);
	}
}
return (res);
}/* FindNamedProd */
