/*
    Eiciel - GNOME editor of ACL file permissions.
    Copyright (C) 2004-2005 Roger Ferrer Ibez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef EICIEL_MAIN_WINDOW_HPP
#define EICIEL_MAIN_WINDOW_HPP

#include <config.hpp>
#include <string>
#include <gtkmm.h>
#include "llista_acl.hpp"
#include "llista_participant.hpp"
#include "eiciel_main_controler.hpp"
#include "tipus_element_acl.hpp"
#include <gettext.h>

using namespace std;

class EicielMainControler;

class EicielWindow : public Gtk::VBox 
{
	public:
		EicielWindow(EicielMainControler* cont);
		virtual ~EicielWindow();

		void afegeixNoSeleccionable(Glib::ustring titol, bool lectura, bool escriptura, bool execucio, TipusElement e,
				bool efectiuLectura = true, bool efectiuEscriptura = true, bool efectiuExecucio = true);
		void afegeixSeleccionable(Glib::ustring titol, bool lectura, bool escriptura, bool execucio, TipusElement e,
				bool efectiuLectura = true, bool efectiuEscriptura = true, bool efectiuExecucio = true);
		void buidaLlistaACL();
		void establirNomFitxer(string nomFitxer);
		void activarBotoDefaultACL(bool b);
		void hiHaDefaultACL(bool b);
		bool donaACLDefault();

        void inicialitzar(string s);
		bool fitxerObert();

		void activacio(bool b);

		void establirNomesLectura(bool b);

		void mostrarAdmiracio(bool b);
		void seleccionarACL(string s, TipusElement e);
		void canviMostrarSystem();

		Glib::ustring ultimError();

	private:
		Gtk::VBox zona_principal;
        
		Glib::RefPtr<Gtk::ListStore> refLlistaACL;
		Gtk::ScrolledWindow contenidorVistaLlistaACL;
		Gtk::TreeView vistaLlistaACL;
        
        Glib::RefPtr<Gtk::ListStore> refLlistaParticipants;
        Gtk::ScrolledWindow contenidorVistaLlistaParticipants;
        Gtk::TreeView vistaLlistaParticipants;
        
        Gtk::HBox selector_participant;
		Gtk::RadioButton ACLusuari;
		Gtk::RadioButton ACLgrup;
        Gtk::CheckButton aclDefault;
		Gtk::ToggleButton modificarACLDefault;
		Gtk::CheckButton mostrarSystem;

		Gtk::HBox botonera_mig;
		Gtk::Button afegirACL;
		Gtk::Button eliminarACL;

		Glib::RefPtr<Gdk::Pixbuf> iconaUsuari;
		Glib::RefPtr<Gdk::Pixbuf> iconaGrup;
		Glib::RefPtr<Gdk::Pixbuf> iconaAltres;
		Glib::RefPtr<Gdk::Pixbuf> iconaMascara;

		Glib::RefPtr<Gdk::Pixbuf> iconaUsuariACL;
		Glib::RefPtr<Gdk::Pixbuf> iconaGrupACL;

		Glib::RefPtr<Gdk::Pixbuf> iconaDefaultUsuari;
		Glib::RefPtr<Gdk::Pixbuf> iconaDefaultGrup;
		Glib::RefPtr<Gdk::Pixbuf> iconaDefaultAltres;
		Glib::RefPtr<Gdk::Pixbuf> iconaDefaultUsuariACL;
		Glib::RefPtr<Gdk::Pixbuf> iconaDefaultGrupACL;
		Glib::RefPtr<Gdk::Pixbuf> iconaDefaultMascara;
		
		Gtk::Frame marc_superior;
		Gtk::VBox zona_superior;
		Gtk::Frame marc_inferior;
		Gtk::VBox zona_inferior;
		
		Gtk::Label llegendaInferior;

		ModelLlistaACL modelLlistaACL;
        ModelLlistaParticipant modelLlistaParticipant;

		Glib::RefPtr<Gtk::UIManager> gestorUI;

		bool modeNomesLectura;

		EicielMainControler* controlador;

		set<string> llistaUsuaris;
		set<string> llistaGrups;


		void noHiHaFitxer();
		void canviDeSeleccioACL();
		void hiHaSeleccioACL();
		void noHiHaSeleccioACL();

		void canviDeSeleccioParticipant();
		void hiHaSeleccioParticipant();
		void noHiHaSeleccioParticipant();
		Glib::RefPtr<Gdk::Pixbuf> retornaIconaApropiada(TipusElement e);
		void afegeixElement(Glib::ustring titol, bool lectura, bool escriptura, bool execucio,
				TipusElement e, Gtk::TreeModel::Row& row,
				bool efectiuLectura, bool efectiuEscriptura, bool efectiuExecucio);
		void eliminarACLSeleccionada();
		void afegirParticipantSeleccionat();
		void canviPermisos(const Glib::ustring& cadena, TipusPermis p);

		void emplenarParticipants(set<string>* participants,
				TipusElement tipus, 
				Glib::RefPtr<Gdk::Pixbuf> iconaNormal,
				Glib::RefPtr<Gdk::Pixbuf> iconaDefecte);


		void dobleClicLlistaParticipants(const Gtk::TreeModel::Path& p, Gtk::TreeViewColumn* c);
		void dobleClicLlistaACL(const Gtk::TreeModel::Path& p, Gtk::TreeViewColumn* c);


		bool funcioSeleccioACL(const Glib::RefPtr<Gtk::TreeModel>& model,
				const Gtk::TreeModel::Path& path, bool);

		void establirValorDragAndDrop(const Glib::RefPtr<Gdk::DragContext>&, 
				Gtk::SelectionData& selection_data, guint, guint);
		void rebreValorDragAndDrop(const Glib::RefPtr<Gdk::DragContext>& context, 
				int, int, const Gtk::SelectionData& selection_data, guint, guint time);

		void iniciDragAndDrop(const Glib::RefPtr<Gdk::DragContext>&);

		void canviarTipusParticipant();
};

#endif
