/* Copyright (C) 2001 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef SETTINGS_H
#define SETTINGS_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <unistd.h>

#include <string>

#include <gtk--/window.h>
#include <gtk--/label.h>
#include <gtk--/table.h>
#include <gtk--/button.h>
#include <gtk--/notebook.h>
#include <gdk--/color.h>
#include <gtk--/entry.h>
#include <gtk--/checkbutton.h>
#include <gtk--/box.h>
#include <gtk--/tooltips.h>

#include "settings_help.h"
#include "prog_defs.h"

class IdentityTable: public  Gtk::Table {
  IdentityMessages help_messages;
  Gtk::Label name_label;
  Gtk::Label number_label;
  Gtk::Entry name_entry;
  Gtk::Entry number_entry;
  Gtk::Button name_help_button;
  Gtk::Button number_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_name(void) {return name_entry.get_text();}
  std::string get_number(void) {return number_entry.get_text();}
  void set_name(const std::string& name) {name_entry.set_text(name);}
  void set_number(const std::string& number) {number_entry.set_text(number);}
  void clear(void);
  IdentityTable(const int);
};

class ModemTable: public  Gtk::Table {
  ModemMessages help_messages;
  Gtk::Label device_label;
  Gtk::Label lock_label;
  Gtk::Label class_label;
  Gtk::Label dialmode_label;
  Gtk::Label capabilities_label;
  Gtk::Label rings_label;
  Gtk::Entry device_entry;
  Gtk::Entry lock_entry;
  Gtk::Entry class_entry;
  Gtk::Entry dialmode_entry;
  Gtk::Entry capabilities_entry;
  Gtk::Entry rings_entry;
  Gtk::Button device_help_button;
  Gtk::Button lock_help_button;
  Gtk::Button class_help_button;
  Gtk::Button dialmode_help_button;
  Gtk::Button capabilities_help_button;
  Gtk::Button rings_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_device(void) {return device_entry.get_text();}
  std::string get_lock(void) {return lock_entry.get_text();}
  std::string get_class(void) {return class_entry.get_text();}
  std::string get_dialmode(void) {return dialmode_entry.get_text();}
  std::string get_capabilities(void) {return capabilities_entry.get_text();}
  std::string get_rings(void) {return rings_entry.get_text();}
  void set_device(const std::string& device) {device_entry.set_text(device);}
  void set_lock(const std::string& lock) {lock_entry.set_text(lock);}
  void set_class(const std::string& class_string) {class_entry.set_text(class_string);}
  void set_dialmode(const std::string& dialmode) {dialmode_entry.set_text(dialmode);}
  void set_capabilities(const std::string& capabilities) {capabilities_entry.set_text(capabilities);}
  void set_rings(const std::string& rings) {rings_entry.set_text(rings);}
  void clear(void);
  ModemTable(const int);
};

class ParmsTable: public  Gtk::Table {
  ParmsMessages help_messages;
  Gtk::Label init_label;
  Gtk::Label reset_label;
  Gtk::Label parms_label;
  Gtk::Entry init_entry;
  Gtk::Entry reset_entry;
  Gtk::Entry parms_entry;
  Gtk::Button init_help_button;
  Gtk::Button reset_help_button;
  Gtk::Button parms_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_init(void) {return init_entry.get_text();}
  std::string get_reset(void) {return reset_entry.get_text();}
  std::string get_parms(void) {return parms_entry.get_text();}
  void set_init(const std::string& init) {init_entry.set_text(init);}
  void set_reset(const std::string& reset) {reset_entry.set_text(reset);}
  void set_parms(const std::string& parms) {parms_entry.set_text(parms);}
  void clear(void);
  ParmsTable(const int);
};

class PrintTable: public  Gtk::Table {
  PrintMessages help_messages;
  Gtk::Label command_label;
  Gtk::Label shrink_label;
  Gtk::Entry command_entry;
  Gtk::Entry shrink_entry;
  Gtk::Button command_help_button;
  Gtk::Button shrink_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_command(void) {return command_entry.get_text();}
  std::string get_shrink(void) {return shrink_entry.get_text();}
  void set_command(const std::string& command) {command_entry.set_text(command);}
  void set_shrink(const std::string& shrink) {shrink_entry.set_text(shrink);}
  void clear(void);
  PrintTable(const int);
};

class ViewTable: public  Gtk::Table {
  ViewMessages help_messages;
  Gtk::Label command_label;
  Gtk::Label res_label;
  Gtk::Entry command_entry;
  Gtk::Entry res_entry;
  Gtk::CheckButton check_button;
  Gtk::HBox check_box;
  Gtk::Button command_help_button;
  Gtk::Button res_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Label filler3;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_command(void) {return command_entry.get_text();}
  std::string get_res(void) {return res_entry.get_text();}
  bool get_multi_file(void) {return check_button.get_active();}
  void set_command(const std::string& command) {command_entry.set_text(command);}
  void set_res(const std::string& res) {res_entry.set_text(res);}
  void set_multi_file(bool active) {check_button.set_active(active);}
  void clear(void);
  ViewTable(const int);
};

class LoggingTable: public  Gtk::Table {
  LoggingMessages help_messages;
  Gtk::Label logfile_label;
  Gtk::Entry logfile_entry;
  Gtk::Button logfile_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_logfile(void) {return logfile_entry.get_text();}
  void set_logfile(const std::string& logfile) {logfile_entry.set_text(logfile);}
  void clear(void);
  LoggingTable(const int);
};

class PageTable: public  Gtk::Table {
  PageMessages help_messages;
  Gtk::Label page_label;
  Gtk::Label res_label;
  Gtk::Entry page_entry;
  Gtk::Entry res_entry;
  Gtk::Button page_help_button;
  Gtk::Button res_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_page(void) {return page_entry.get_text();}
  std::string get_res(void) {return res_entry.get_text();}
  void set_page(const std::string& page) {page_entry.set_text(page);}
  void set_res(const std::string& res) {res_entry.set_text(res);}
  void clear(void);
  PageTable(const int);
};

class SettingsDialog: public Gtk::Window {

  const int standard_size;
  bool in_run_loop;
  bool is_home_config;
  std::string rcfile;

  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::Table window_table;
  Gtk::Notebook notebook;
  const Gdk_Color red;
  Gtk::Window& parent;

  IdentityTable identity_table;
  ModemTable modem_table;
  ParmsTable parms_table;
  PrintTable print_table;
  ViewTable view_table;
  LoggingTable logging_table;
  PageTable page_table;

  void selected(bool);
  void read_config(bool search_localfile = true);
  bool write_config(void);
  bool get_prog_parm(const char*, std::string&, std::string&);
  bool find_prog_parm(const char*, const string&);
  bool get_rcfile_path(bool search_localfile = true);
  void get_reset_settings_prompt(void);
  void get_reset_settings(void);
  void show_help(const string& message, const string& caption);
  void strip(string&);
protected:
  virtual gint delete_event_impl(GdkEventAny*);
public:
  // this signal can be used to indicate that settings have changed
  // it is emitted after this dialog has rewritten the ~/.efax-gtkrc
  // and has called configure_prog() and passes the messages
  // returned by configure_prog()
  SigC::Signal1<void, const std::string&> accepted;
  void run(void);
  SettingsDialog(const int standard_size, Gtk::Window& window, bool skip_old_settings = false);
};

#endif
