<?xml version="1.0"?>

<!--
 This file is part of EdiTeX, an editor of mathematical
 expressions based on TeX syntax.
 
 Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 For more information, please visit the project's home page
 http://helm.cs.unibo.it/editex/
 or send an email to <lpadovan@cs.unibo.it>
-->

<!-- TML ===> TeX + Long Identifiers                                -->
<!-- Example: <tml:i val="hello"/> is transformed simply to "hello" -->
<!-- and not to its TeX "rendering" "{\rm hello}"                   -->

<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
     xmlns:tml="http://helm.cs.unibo.it/2002/TML"
     xmlns:m="http://www.w3.org/1998/Math/MathML"
     version="1.0">

  <xsl:output method="text" indent="yes"/>

  <xsl:param name="id" select="/.."/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="$id">
        <xsl:apply-templates select="descendant::*[@id=$id]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="*"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:tex">
    <xsl:apply-templates select="*"/>
  </xsl:template>

  <xsl:template match="tml:math">
    <xsl:choose>
      <xsl:when test="@display='1'">$$<xsl:apply-templates select="*"/>$$</xsl:when>
      <xsl:otherwise>$<xsl:apply-templates select="*"/>$</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:i">
    <xsl:choose>
      <xsl:when test="@name">\<xsl:value-of select="@name"/>
        <xsl:if test="parent::tml:g and following-sibling::tml:i"><xsl:value-of select="' '"/></xsl:if>
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="@val"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:n">
    <xsl:choose>
      <xsl:when test="@name">\<xsl:value-of select="@name"/>
        <xsl:if test="parent::tml:g and following-sibling::tml:i"><xsl:value-of select="' '"/></xsl:if>
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="@val"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:o">
    <xsl:choose>
      <xsl:when test="@name">\<xsl:value-of select="@name"/>
        <xsl:if test="parent::tml:g and following-sibling::tml:i"><xsl:value-of select="' '"/></xsl:if>
      </xsl:when>
      <xsl:when test="string-length(@val)=1"><xsl:value-of select="@val"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="@val"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:s">
    <xsl:text> </xsl:text>
  </xsl:template>

  <xsl:template match="tml:sb">
    <xsl:choose>
      <xsl:when test="@under='1'">
        <xsl:apply-templates select="*[1]"/>__<xsl:apply-templates select="*[2]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="*[1]"/>_<xsl:apply-templates select="*[2]"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:sp">
    <xsl:choose>
      <xsl:when test="@over='1'">
        <xsl:apply-templates select="*[1]"/>^^<xsl:apply-templates select="*[2]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="*[1]"/>^<xsl:apply-templates select="*[2]"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tml:g[@id]">{<xsl:apply-templates select="*"/>}</xsl:template>

  <xsl:template match="tml:g[count(*)&gt;1]">{<xsl:apply-templates select="*"/>}</xsl:template>

  <xsl:template match="tml:g">
    <xsl:apply-templates select="*"/>
  </xsl:template>

  <xsl:template match="tml:row">
    <xsl:apply-templates select="cell"/>\cr </xsl:template>

  <xsl:template match="tml:cell">
    <xsl:apply-templates select="*"/>
    <xsl:if test="position() &lt; last()">&amp;</xsl:if>
  </xsl:template>

<!--/// CONTROL SEQUENCES ///-->

  <xsl:template match="tml:c[*[1][self::tml:g[@left-open='1']]]">
    <xsl:apply-templates select="*[1]"/>\<xsl:value-of select="@name"/>
    <xsl:if test="*[2][self::tml:i]"><xsl:value-of select="' '"/></xsl:if>
    <xsl:apply-templates select="*[position()&gt;1]"/>
  </xsl:template>

  <xsl:template match="tml:c">\<xsl:value-of select="@name"/>
    <xsl:if test="*[1][self::tml:i]"><xsl:value-of select="' '"/></xsl:if>
    <xsl:apply-templates select="*"/>
  </xsl:template>

<!--/// CURSOR ///-->

  <xsl:template match="tml:cursor[@val]">
    <xsl:choose>
      <xsl:when test="string-length(@val)=0"/>
      <xsl:otherwise><xsl:value-of select="@val"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>

