(* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 *)

let default_dictionary_path = I_mathml_editor.get_default_dictionary_path ()
;;

let default_mathml_stylesheet_path = I_mathml_editor.get_default_mathml_stylesheet_path ()
;;

let default_tex_stylesheet_path = I_mathml_editor.get_default_tex_stylesheet_path ()
;;

let create ?(alt_lexer=false) ~dictionary_uri ~mml_uri ~tml_uri ~log =
  I_mathml_editor.create ~alt_lexer ~dictionary_uri ~mml_uri ~tml_uri ~log
;;

let freeze = I_mathml_editor.freeze
;;

let thaw = I_mathml_editor.thaw
;;

let reset = I_mathml_editor.reset
;;

let push = I_mathml_editor.push
;;

let drop = I_mathml_editor.drop
;;

let cursor_hide = I_mathml_editor.cursor_hide
;;

let cursor_show = I_mathml_editor.cursor_show
;;

let get_tex = I_mathml_editor.get_tex
;;

let get_tml ~editor =
  new Gdome.document (I_mathml_editor.get_tml ~editor)
;;

let get_mml ~editor =
  new Gdome.document (I_mathml_editor.get_mml ~editor)
;;

