/*
***************************************************************************
*
* Author: Teunis van Beelen
*
* Copyright (C) 2007, 2008, 2009, 2010 Teunis van Beelen
*
* teuniz@gmail.com
*
***************************************************************************
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
***************************************************************************
*
* This version of GPL is at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
*
***************************************************************************
*/



#include "options_dialog.h"




UI_OptionsDialog::UI_OptionsDialog(QWidget *parent)
{
  int i;

  mainwindow = (UI_Mainwindow *)parent;

  optionsdialog = new QDialog(parent);

  optionsdialog->setMinimumSize(QSize(415, 735));
  optionsdialog->setMaximumSize(QSize(415, 735));
  optionsdialog->setWindowTitle("Options");
  optionsdialog->setModal(TRUE);
  optionsdialog->setAttribute(Qt::WA_DeleteOnClose, TRUE);

  tabholder = new QTabWidget(optionsdialog);
  tabholder->setMinimumSize(QSize(415, 670));
  tabholder->setMaximumSize(QSize(415, 670));

  CloseButton = new QPushButton(optionsdialog);
  CloseButton->setGeometry(QRect(240, 690, 100, 25));
  CloseButton->setText("Close");

  tab1 = new QWidget;

  label1 = new QLabel(tab1);
  label1->setGeometry(QRect(20, 20, 200, 25));
  label1->setText("Background color");

  BgColorButton = new SpecialButton(tab1);
  BgColorButton->setGeometry(QRect(240, 20, 100, 25));
  BgColorButton->setColor(mainwindow->maincurve->backgroundcolor);

  label2 = new QLabel(tab1);
  label2->setGeometry(QRect(20, 65, 200, 25));
  label2->setText("Small ruler color");

  SrColorButton = new SpecialButton(tab1);
  SrColorButton->setGeometry(QRect(240, 65, 100, 25));
  SrColorButton->setColor(mainwindow->maincurve->small_ruler_color);

  label3 = new QLabel(tab1);
  label3->setGeometry(QRect(20, 110, 200, 25));
  label3->setText("Big ruler color");

  BrColorButton = new SpecialButton(tab1);
  BrColorButton->setGeometry(QRect(240, 110, 100, 25));
  BrColorButton->setColor(mainwindow->maincurve->big_ruler_color);

  label4 = new QLabel(tab1);
  label4->setGeometry(QRect(20, 155, 200, 25));
  label4->setText("Mouse rectangle color");

  MrColorButton = new SpecialButton(tab1);
  MrColorButton->setGeometry(QRect(240, 155, 100, 25));
  MrColorButton->setColor(mainwindow->maincurve->mouse_rect_color);

  label5 = new QLabel(tab1);
  label5->setGeometry(QRect(20, 200, 200, 25));
  label5->setText("Text color");

  TxtColorButton = new SpecialButton(tab1);
  TxtColorButton->setGeometry(QRect(240, 200, 100, 25));
  TxtColorButton->setColor(mainwindow->maincurve->text_color);

  label6 = new QLabel(tab1);
  label6->setGeometry(QRect(20, 245, 200, 25));
  label6->setText("Signals color");

  SigColorButton = new SpecialButton(tab1);
  SigColorButton->setGeometry(QRect(240, 245, 100, 25));
  SigColorButton->setColor((Qt::GlobalColor)mainwindow->maincurve->signal_color);

  label7 = new QLabel(tab1);
  label7->setGeometry(QRect(20, 290, 200, 25));
  label7->setText("Baseline color");

  checkbox3 = new QCheckBox(tab1);
  checkbox3->setGeometry(QRect(200, 293, 20, 20));
  checkbox3->setTristate(FALSE);
  if(mainwindow->show_baselines)
  {
    checkbox3->setCheckState(Qt::Checked);
  }
  else
  {
    checkbox3->setCheckState(Qt::Unchecked);
  }

  BaseColorButton = new SpecialButton(tab1);
  BaseColorButton->setGeometry(QRect(240, 290, 100, 25));
  BaseColorButton->setColor(mainwindow->maincurve->baseline_color);

  label8 = new QLabel(tab1);
  label8->setGeometry(QRect(20, 335, 200, 25));
  label8->setText("Crosshair color");

  Crh1ColorButton = new SpecialButton(tab1);
  Crh1ColorButton->setGeometry(QRect(240, 335, 100, 25));
  Crh1ColorButton->setColor((Qt::GlobalColor)mainwindow->maincurve->crosshair_1_color);

  label9 = new QLabel(tab1);
  label9->setGeometry(QRect(20, 380, 200, 25));
  label9->setText("2th Crosshair color");

  Crh2ColorButton = new SpecialButton(tab1);
  Crh2ColorButton->setGeometry(QRect(240, 380, 100, 25));
  Crh2ColorButton->setColor((Qt::GlobalColor)mainwindow->maincurve->crosshair_2_color);

  label10 = new QLabel(tab1);
  label10->setGeometry(QRect(20, 425, 200, 25));
  label10->setText("Floating ruler color");

  FrColorButton = new SpecialButton(tab1);
  FrColorButton->setGeometry(QRect(240, 425, 100, 25));
  FrColorButton->setColor((Qt::GlobalColor)mainwindow->maincurve->floating_ruler_color);

  label12 = new QLabel(tab1);
  label12->setGeometry(QRect(20, 470, 200, 25));
  label12->setText("Annotation marker");

  checkbox2 = new QCheckBox(tab1);
  checkbox2->setGeometry(QRect(200, 473, 20, 20));
  checkbox2->setTristate(FALSE);
  if(mainwindow->show_annot_markers)
  {
    checkbox2->setCheckState(Qt::Checked);
  }
  else
  {
    checkbox2->setCheckState(Qt::Unchecked);
  }

  AnnotMkrButton = new SpecialButton(tab1);
  AnnotMkrButton->setGeometry(QRect(240, 470, 100, 25));
  AnnotMkrButton->setColor(mainwindow->maincurve->annot_marker_color);

  label11 = new QLabel(tab1);
  label11->setGeometry(QRect(20, 515, 200, 25));
  label11->setText("Print in grayscale");

  checkbox1 = new QCheckBox(tab1);
  checkbox1->setGeometry(QRect(200, 518, 20, 20));
  checkbox1->setTristate(FALSE);
  if(mainwindow->maincurve->blackwhite_printing)
  {
    checkbox1->setCheckState(Qt::Checked);
  }
  else
  {
    checkbox1->setCheckState(Qt::Unchecked);
  }

  DefaultButton = new QPushButton(tab1);
  DefaultButton->setGeometry(QRect(20, 605, 100, 25));
  DefaultButton->setText("Restore default");

  QObject::connect(BgColorButton,   SIGNAL(clicked(SpecialButton *)), this,          SLOT(BgColorButtonClicked(SpecialButton *)));
  QObject::connect(SrColorButton,   SIGNAL(clicked(SpecialButton *)), this,          SLOT(SrColorButtonClicked(SpecialButton *)));
  QObject::connect(BrColorButton,   SIGNAL(clicked(SpecialButton *)), this,          SLOT(BrColorButtonClicked(SpecialButton *)));
  QObject::connect(MrColorButton,   SIGNAL(clicked(SpecialButton *)), this,          SLOT(MrColorButtonClicked(SpecialButton *)));
  QObject::connect(TxtColorButton,  SIGNAL(clicked(SpecialButton *)), this,          SLOT(TxtColorButtonClicked(SpecialButton *)));
  QObject::connect(SigColorButton,  SIGNAL(clicked(SpecialButton *)), this,          SLOT(SigColorButtonClicked(SpecialButton *)));
  QObject::connect(BaseColorButton, SIGNAL(clicked(SpecialButton *)), this,          SLOT(BaseColorButtonClicked(SpecialButton *)));
  QObject::connect(Crh1ColorButton, SIGNAL(clicked(SpecialButton *)), this,          SLOT(Crh1ColorButtonClicked(SpecialButton *)));
  QObject::connect(Crh2ColorButton, SIGNAL(clicked(SpecialButton *)), this,          SLOT(Crh2ColorButtonClicked(SpecialButton *)));
  QObject::connect(FrColorButton,   SIGNAL(clicked(SpecialButton *)), this,          SLOT(FrColorButtonClicked(SpecialButton *)));
  QObject::connect(AnnotMkrButton,  SIGNAL(clicked(SpecialButton *)), this,          SLOT(AnnotMkrButtonClicked(SpecialButton *)));
  QObject::connect(checkbox1,       SIGNAL(stateChanged(int)),        this,          SLOT(checkbox1Clicked(int)));
  QObject::connect(checkbox2,       SIGNAL(stateChanged(int)),        this,          SLOT(checkbox2Clicked(int)));
  QObject::connect(checkbox3,       SIGNAL(stateChanged(int)),        this,          SLOT(checkbox3Clicked(int)));
  QObject::connect(DefaultButton,   SIGNAL(clicked()),                this,          SLOT(DefaultButtonClicked()));
  QObject::connect(CloseButton,     SIGNAL(clicked()),                optionsdialog, SLOT(close()));

  tabholder->addTab(tab1, "Colors");

  tab2 = new QWidget;

  label2_1 = new SpecialButton(tab2);
  label2_1->setGeometry(30, 20, 10, 445);
  label2_1->setColor(Qt::black);

  label2_2 = new QLabel(tab2);
  label2_2->setGeometry(QRect(85, 50, 220, 50));
  label2_2->setText("Measure the length of the black\nrectangle and enter the value.");

  spinbox = new QSpinBox(tab2);
  spinbox->setGeometry(QRect(85, 240, 100, 20));
  spinbox->setSuffix(" mm");
  spinbox->setMinimum(10);
  spinbox->setMaximum(500);
  spinbox->setValue((int)(4450.0 / (1.0 / mainwindow->pixelsizefactor)));

  ApplyButton = new QPushButton(tab2);
  ApplyButton->setGeometry(QRect(85, 300, 100, 25));
  ApplyButton->setText("Apply");

  QObject::connect(ApplyButton, SIGNAL(clicked()), this, SLOT(ApplyButtonClicked()));

  tabholder->addTab(tab2, "Calibration");

  tab3 = new QWidget;

  label1_3 = new QLabel(tab3);
  label1_3->setGeometry(QRect(20, 20, 330, 25));
  label1_3->setText("Frequency regions of the colorbars:");

  colorBarTable = new QTableWidget(tab3);
  colorBarTable->setGeometry(20, 50, 370, 350);
  colorBarTable->setSelectionMode(QAbstractItemView::NoSelection);
  colorBarTable->setColumnCount(4);
  colorBarTable->setColumnWidth(0, 20);
  colorBarTable->setColumnWidth(1, 140);
  colorBarTable->setColumnWidth(2, 80);
  colorBarTable->setColumnWidth(3, 100);
  colorBarTable->setRowCount(MAXSPECTRUMMARKERS);
  for(i=0; i < MAXSPECTRUMMARKERS; i++)
  {
    colorBarTable->setRowHeight(i, 20);

    colorBarTable->setCellWidget(i, 0, new QCheckBox);
   ((QCheckBox *)(colorBarTable->cellWidget(i, 0)))->setTristate(FALSE);
    if(i < mainwindow->spectrum_colorbar->items)
    {
      ((QCheckBox *)(colorBarTable->cellWidget(i, 0)))->setCheckState(Qt::Checked);
    }
    else
    {
      ((QCheckBox *)(colorBarTable->cellWidget(i, 0)))->setCheckState(Qt::Unchecked);
    }
    QObject::connect(colorBarTable->cellWidget(i, 0), SIGNAL(stateChanged(int)), this, SLOT(checkBoxChanged(int)));

    colorBarTable->setCellWidget(i, 1, new QDoubleSpinBox);
    ((QDoubleSpinBox *)(colorBarTable->cellWidget(i, 1)))->setDecimals(3);
    ((QDoubleSpinBox *)(colorBarTable->cellWidget(i, 1)))->setSuffix(" Hz");
    ((QDoubleSpinBox *)(colorBarTable->cellWidget(i, 1)))->setRange(0.001, 100000.0);
    ((QDoubleSpinBox *)(colorBarTable->cellWidget(i, 1)))->setValue(mainwindow->spectrum_colorbar->freq[i]);
    QObject::connect((QDoubleSpinBox *)(colorBarTable->cellWidget(i, 1)), SIGNAL(valueChanged(double)), this, SLOT(spinBoxValueChanged(double)));

    colorBarTable->setCellWidget(i, 2, new SpecialButton);
    ((SpecialButton *)(colorBarTable->cellWidget(i, 2)))->setGlobalColor(mainwindow->spectrum_colorbar->color[i]);
    QObject::connect((SpecialButton *)(colorBarTable->cellWidget(i, 2)), SIGNAL(clicked(SpecialButton *)), this, SLOT(colorBarButtonClicked(SpecialButton *)));

    colorBarTable->setCellWidget(i, 3, new QLineEdit);
    ((QLineEdit *)(colorBarTable->cellWidget(i, 3)))->setText(mainwindow->spectrum_colorbar->label[i]);
    ((QLineEdit *)(colorBarTable->cellWidget(i, 3)))->setMaxLength(16);
    QObject::connect((QLineEdit *)(colorBarTable->cellWidget(i, 3)), SIGNAL(textEdited(const QString  &)), this, SLOT(labelEdited(const QString  &)));
  }

  QStringList horizontallabels;
  horizontallabels += "";
  horizontallabels += "Frequency";
  horizontallabels += "Color";
  horizontallabels += "Label";
  colorBarTable->setHorizontalHeaderLabels(horizontallabels);

  label2_3 = new QLabel(tab3);
  label2_3->setGeometry(QRect(20, 410, 310, 25));
  label2_3->setText("Height of colorbars are relative to the");

  radiobutton1 = new QRadioButton(tab3);
  radiobutton1->setGeometry(QRect(20, 435, 200, 25));
  radiobutton1->setText("sum");
  if(mainwindow->spectrum_colorbar->method == 0)
  {
    radiobutton1->setChecked(TRUE);  // sum
  }

  radiobutton2 = new QRadioButton(tab3);
  radiobutton2->setGeometry(QRect(20, 460, 200, 25));
  radiobutton2->setText("peak");
  if(mainwindow->spectrum_colorbar->method == 1)
  {
    radiobutton2->setChecked(TRUE);  // peak
  }

  radiobutton3 = new QRadioButton(tab3);
  radiobutton3->setGeometry(QRect(20, 485, 200, 25));
  radiobutton3->setText("average");
  if(mainwindow->spectrum_colorbar->method == 2)
  {
    radiobutton3->setChecked(TRUE);  // average
  }

  label3_3 = new QLabel(tab3);
  label3_3->setGeometry(QRect(20, 515, 310, 25));
  label3_3->setText("of the power in the colorbar region.");

  label3_4 = new QLabel(tab3);
  label3_4->setGeometry(QRect(20, 550, 120, 25));
  label3_4->setText("FFT blocksize:");

  spinbox3_1 = new QSpinBox(tab3);
  spinbox3_1->setGeometry(QRect(140, 550, 140, 20));
  spinbox3_1->setSuffix(" samples");
  spinbox3_1->setMinimum(10);
  spinbox3_1->setMaximum(32768);
  spinbox3_1->setSingleStep(2);
  spinbox3_1->setValue(mainwindow->maxdftblocksize);

  DefaultButton2 = new QPushButton(tab3);
  DefaultButton2->setGeometry(QRect(245, 605, 100, 25));
  DefaultButton2->setText("Restore default");

  ApplyButton2 = new QPushButton(tab3);
  ApplyButton2->setGeometry(QRect(20, 605, 100, 25));
  ApplyButton2->setText("Apply");
  ApplyButton2->setEnabled(FALSE);

  QObject::connect(radiobutton1,   SIGNAL(toggled(bool)),     this, SLOT(radioButtonToggled(bool)));
  QObject::connect(radiobutton2,   SIGNAL(toggled(bool)),     this, SLOT(radioButtonToggled(bool)));
  QObject::connect(radiobutton3,   SIGNAL(toggled(bool)),     this, SLOT(radioButtonToggled(bool)));
  QObject::connect(spinbox3_1,     SIGNAL(valueChanged(int)), this, SLOT(spinBox3_3ValueChanged(int)));
  QObject::connect(ApplyButton2,   SIGNAL(clicked()),         this, SLOT(ApplyButton2Clicked()));
  QObject::connect(DefaultButton2, SIGNAL(clicked()),         this, SLOT(DefaultButton2Clicked()));

  tabholder->addTab(tab3, "Powerspectrum");

  optionsdialog->exec();
}


void UI_OptionsDialog::labelEdited(const QString  &)
{
  ApplyButton2->setEnabled(TRUE);
}


void UI_OptionsDialog::spinBox3_3ValueChanged(int)
{
  ApplyButton2->setEnabled(TRUE);
}


void UI_OptionsDialog::radioButtonToggled(bool)
{
  ApplyButton2->setEnabled(TRUE);
}


void UI_OptionsDialog::spinBoxValueChanged(double)
{
  ApplyButton2->setEnabled(TRUE);
}


void UI_OptionsDialog::ApplyButton2Clicked()
{
  int row;

  char str[256];

  for(row = 1; row < MAXSPECTRUMMARKERS; row++)
  {
    if(((QCheckBox *)(colorBarTable->cellWidget(row, 0)))->checkState() == Qt::Checked)
    {
      if(((QDoubleSpinBox *)(colorBarTable->cellWidget(row - 1, 1)))->value() >= ((QDoubleSpinBox *)(colorBarTable->cellWidget(row, 1)))->value())
      {
        sprintf(str, "Row %i must have a higher frequency than row %i", row + 1, row);

        UI_Messagewindow popup("Error", str);

        return;
      }
    }
    else
    {
      break;
    }
  }

  for(row = 0; row < MAXSPECTRUMMARKERS; row++)
  {
    if(((QCheckBox *)(colorBarTable->cellWidget(row, 0)))->checkState() == Qt::Checked)
    {
      mainwindow->spectrum_colorbar->freq[row] = ((QDoubleSpinBox *)(colorBarTable->cellWidget(row, 1)))->value();
      mainwindow->spectrum_colorbar->color[row] = ((SpecialButton *)(colorBarTable->cellWidget(row, 2)))->globalColor();
      strncpy(mainwindow->spectrum_colorbar->label[row], ((QLineEdit *)(colorBarTable->cellWidget(row, 3)))->text().toLatin1().data(), 16);
      mainwindow->spectrum_colorbar->label[row][16] = 0;
    }
    else
    {
      break;
    }
  }

  mainwindow->spectrum_colorbar->items = row;

  for(; row < MAXSPECTRUMMARKERS; row++)
  {
    mainwindow->spectrum_colorbar->freq[row] = ((QDoubleSpinBox *)(colorBarTable->cellWidget(row, 1)))->value();
    mainwindow->spectrum_colorbar->color[row] = ((SpecialButton *)(colorBarTable->cellWidget(row, 2)))->globalColor();
  }

  if(radiobutton1->isChecked()) // sum
  {
    mainwindow->spectrum_colorbar->method = 0;
  }
  else
    if(radiobutton2->isChecked()) // peak
    {
      mainwindow->spectrum_colorbar->method = 1;
    }
    else
      if(radiobutton3->isChecked()) // average
      {
        mainwindow->spectrum_colorbar->method = 2;
      }

  mainwindow->maxdftblocksize = spinbox3_1->value();
  if(mainwindow->maxdftblocksize & 1)
  {
    mainwindow->maxdftblocksize--;
  }

  ApplyButton2->setEnabled(FALSE);
}


void UI_OptionsDialog::checkBoxChanged(int state)
{
  int i,
      row,
      lastrow=0;

  if(state == Qt::Checked)
  {
    for(row = MAXSPECTRUMMARKERS - 1; row >= 0; row--)
    {
      if(((QCheckBox *)(colorBarTable->cellWidget(row, 0)))->checkState() == Qt::Checked)
      {
        lastrow = row;

        if(row)
        {
          for(i=row-1; i>=0; i--)
          {
            ((QCheckBox *)(colorBarTable->cellWidget(i, 0)))->setCheckState(Qt::Checked);
          }
        }

        break;
      }
    }
  }
  else
  {
    for(row = 0; row < MAXSPECTRUMMARKERS; row++)
    {
      if(((QCheckBox *)(colorBarTable->cellWidget(row, 0)))->checkState() == Qt::Unchecked)
      {
        lastrow = row - 1;

        for(; row < MAXSPECTRUMMARKERS; row++)
        {
          ((QCheckBox *)(colorBarTable->cellWidget(row, 0)))->setCheckState(Qt::Unchecked);
        }

        break;
      }
    }
  }

  for(row=0; row < lastrow; row++)
  {
    if(((QDoubleSpinBox *)(colorBarTable->cellWidget(row, 1)))->value() >= ((QDoubleSpinBox *)(colorBarTable->cellWidget(row + 1, 1)))->value())
    {
      ((QDoubleSpinBox *)(colorBarTable->cellWidget(row + 1, 1)))->setValue(((QDoubleSpinBox *)(colorBarTable->cellWidget(row, 1)))->value() + 1.0);
    }
  }

  ApplyButton2->setEnabled(TRUE);
}


void UI_OptionsDialog::DefaultButton2Clicked()
{
  int i;

  for(i=0; i<5; i++)
  {
    ((QCheckBox *)(colorBarTable->cellWidget(i, 0)))->setCheckState(Qt::Checked);
    ((QLineEdit *)(colorBarTable->cellWidget(i, 3)))->clear();
  }

  ((QDoubleSpinBox *)(colorBarTable->cellWidget(0, 1)))->setValue(4.0);
  ((SpecialButton *)(colorBarTable->cellWidget(0, 2)))->setGlobalColor(Qt::darkRed);

  ((QDoubleSpinBox *)(colorBarTable->cellWidget(1, 1)))->setValue(8.0);
  ((SpecialButton *)(colorBarTable->cellWidget(1, 2)))->setGlobalColor(Qt::darkGreen);

  ((QDoubleSpinBox *)(colorBarTable->cellWidget(2, 1)))->setValue(12.0);
  ((SpecialButton *)(colorBarTable->cellWidget(2, 2)))->setGlobalColor(Qt::darkBlue);

  ((QDoubleSpinBox *)(colorBarTable->cellWidget(3, 1)))->setValue(30.0);
  ((SpecialButton *)(colorBarTable->cellWidget(3, 2)))->setGlobalColor(Qt::darkCyan);

  ((QDoubleSpinBox *)(colorBarTable->cellWidget(4, 1)))->setValue(100.0);
  ((SpecialButton *)(colorBarTable->cellWidget(4, 2)))->setGlobalColor(Qt::darkMagenta);

  for(i=5; i<MAXSPECTRUMMARKERS; i++)
  {
    ((QCheckBox *)(colorBarTable->cellWidget(i, 0)))->setCheckState(Qt::Unchecked);
    ((QDoubleSpinBox *)(colorBarTable->cellWidget(i, 1)))->setValue(1.0);
    ((SpecialButton *)(colorBarTable->cellWidget(i, 2)))->setGlobalColor(Qt::white);
    ((QLineEdit *)(colorBarTable->cellWidget(i, 3)))->clear();
  }

  spinbox3_1->setValue(1000);

  radiobutton2->setChecked(TRUE);

  ApplyButton2->setEnabled(TRUE);
}


void UI_OptionsDialog::colorBarButtonClicked(SpecialButton *button)
{
  int color;

  UI_ColorMenuDialog colormenudialog(&color);

  if(color < 0)  return;

  button->setGlobalColor(color);

  ApplyButton2->setEnabled(TRUE);
}


void UI_OptionsDialog::checkbox1Clicked(int state)
{
  if(state==Qt::Checked)
  {
    mainwindow->maincurve->blackwhite_printing = 1;
  }

  if(state==Qt::Unchecked)
  {
    mainwindow->maincurve->blackwhite_printing = 0;
  }
}


void UI_OptionsDialog::checkbox2Clicked(int state)
{
  if(state==Qt::Checked)
  {
    mainwindow->show_annot_markers = 1;
  }

  if(state==Qt::Unchecked)
  {
    mainwindow->show_annot_markers = 0;
  }

  mainwindow->maincurve->update();
}


void UI_OptionsDialog::checkbox3Clicked(int state)
{
  if(state==Qt::Checked)
  {
    mainwindow->show_baselines = 1;
  }

  if(state==Qt::Unchecked)
  {
    mainwindow->show_baselines = 0;
  }

  mainwindow->maincurve->update();
}


void UI_OptionsDialog::ApplyButtonClicked()
{
  int i, j;


  mainwindow->pixelsizefactor = 1.0 / (4450.0 / spinbox->value());

  for(i=0; i<mainwindow->signalcomps; i++)
  {
    for(j=0; j<mainwindow->signalcomp[i]->num_of_signals; j++)
    {
      mainwindow->signalcomp[i]->sensitivity[j] =
       mainwindow->signalcomp[i]->edfhdr->edfparam[mainwindow->signalcomp[i]->edfsignal[j]].bitvalue
       / ((double)mainwindow->signalcomp[i]->voltpercm
       * mainwindow->pixelsizefactor);
    }
  }

  mainwindow->maincurve->drawCurve_stage_1();
}



void UI_OptionsDialog::DefaultButtonClicked()
{
  int i;

  QPalette palette;

  mainwindow->maincurve->backgroundcolor = Qt::gray;
  BgColorButton->setColor(mainwindow->maincurve->backgroundcolor);

  mainwindow->maincurve->small_ruler_color = Qt::black;
  SrColorButton->setColor(mainwindow->maincurve->small_ruler_color);

  mainwindow->maincurve->big_ruler_color = Qt::darkGray;
  BrColorButton->setColor(mainwindow->maincurve->big_ruler_color);

  mainwindow->maincurve->mouse_rect_color = Qt::black;
  MrColorButton->setColor(mainwindow->maincurve->mouse_rect_color);

  mainwindow->maincurve->text_color = Qt::black;
  TxtColorButton->setColor(mainwindow->maincurve->text_color);

  mainwindow->maincurve->signal_color = Qt::blue;
  SigColorButton->setColor(Qt::blue);

  mainwindow->maincurve->baseline_color = Qt::darkGray;
  BaseColorButton->setColor(Qt::darkGray);
  mainwindow->show_baselines = 1;
  checkbox3->setCheckState(Qt::Checked);

  mainwindow->maincurve->crosshair_1_color = Qt::red;
  Crh1ColorButton->setColor(Qt::red);

  mainwindow->maincurve->crosshair_2_color = Qt::cyan;
  Crh2ColorButton->setColor(Qt::cyan);

  mainwindow->maincurve->floating_ruler_color = Qt::red;
  FrColorButton->setColor(Qt::red);

  mainwindow->maincurve->annot_marker_color = Qt::white;
  AnnotMkrButton->setColor(Qt::white);
  mainwindow->show_annot_markers = 1;
  checkbox2->setCheckState(Qt::Checked);

  palette.setColor(QPalette::Text, mainwindow->maincurve->text_color);
  palette.setColor(QPalette::Base, mainwindow->maincurve->backgroundcolor);

  for(i=0; i<mainwindow->files_open; i++)
  {
    if(mainwindow->annotations_dock[i])
    {
      mainwindow->annotations_dock[i]->list->setPalette(palette);
    }
  }

  for(i=0; i<mainwindow->signalcomps; i++)
  {
    mainwindow->signalcomp[i]->color = mainwindow->maincurve->signal_color;
  }

  mainwindow->maincurve->blackwhite_printing = 1;

  checkbox1->setCheckState(Qt::Checked);

  mainwindow->maincurve->update();
}



void UI_OptionsDialog::BgColorButtonClicked(SpecialButton *)
{
  int i;

  QColor temp;

  QPalette palette;

  temp = QColorDialog::getColor(mainwindow->maincurve->backgroundcolor, tab1);

  if(temp.isValid())
  {
    mainwindow->maincurve->backgroundcolor = temp;

    BgColorButton->setColor(mainwindow->maincurve->backgroundcolor);

    palette.setColor(QPalette::Text, mainwindow->maincurve->text_color);
    palette.setColor(QPalette::Base, mainwindow->maincurve->backgroundcolor);

    for(i=0; i<mainwindow->files_open; i++)
    {
      if(mainwindow->annotations_dock[i])
      {
        mainwindow->annotations_dock[i]->list->setPalette(palette);
      }
    }

    mainwindow->maincurve->update();
  }
}



void UI_OptionsDialog::SrColorButtonClicked(SpecialButton *)
{
  QColor temp;

  temp = QColorDialog::getColor(mainwindow->maincurve->small_ruler_color, tab1);

  if(temp.isValid())
  {
    mainwindow->maincurve->small_ruler_color = temp;

    SrColorButton->setColor(mainwindow->maincurve->small_ruler_color);

    mainwindow->maincurve->update();
  }
}



void UI_OptionsDialog::BrColorButtonClicked(SpecialButton *)
{
  QColor temp;

  temp = QColorDialog::getColor(mainwindow->maincurve->big_ruler_color, tab1);

  if(temp.isValid())
  {
    mainwindow->maincurve->big_ruler_color = temp;

    BrColorButton->setColor(mainwindow->maincurve->big_ruler_color);

    mainwindow->maincurve->update();
  }
}



void UI_OptionsDialog::MrColorButtonClicked(SpecialButton *)
{
  QColor temp;

  temp = QColorDialog::getColor(mainwindow->maincurve->mouse_rect_color, tab1);

  if(temp.isValid())
  {
    mainwindow->maincurve->mouse_rect_color = temp;

    MrColorButton->setColor(mainwindow->maincurve->mouse_rect_color);

    mainwindow->maincurve->update();
  }
}



void UI_OptionsDialog::TxtColorButtonClicked(SpecialButton *)
{
  int i;

  QColor temp;

  QPalette palette;

  temp = QColorDialog::getColor(mainwindow->maincurve->text_color, tab1);

  if(temp.isValid())
  {
    mainwindow->maincurve->text_color = temp;

    TxtColorButton->setColor(mainwindow->maincurve->text_color);

    palette.setColor(QPalette::Text, mainwindow->maincurve->text_color);
    palette.setColor(QPalette::Base, mainwindow->maincurve->backgroundcolor);

    for(i=0; i<mainwindow->files_open; i++)
    {
      if(mainwindow->annotationlist[i])
      {
        mainwindow->annotations_dock[i]->list->setPalette(palette);
      }
    }

    mainwindow->maincurve->update();
  }
}



void UI_OptionsDialog::SigColorButtonClicked(SpecialButton *)
{
  int i, color;

  UI_ColorMenuDialog colormenudialog(&color);

  if(color < 0)  return;

  SigColorButton->setColor((Qt::GlobalColor)color);

  mainwindow->maincurve->signal_color = color;

  for(i=0; i<mainwindow->signalcomps; i++)
  {
    mainwindow->signalcomp[i]->color = color;
  }

  mainwindow->maincurve->update();
}



void UI_OptionsDialog::BaseColorButtonClicked(SpecialButton *)
{
  QColor temp;

  temp = QColorDialog::getColor(mainwindow->maincurve->baseline_color, tab1);

  if(temp.isValid())
  {
    mainwindow->maincurve->baseline_color = temp;

    BaseColorButton->setColor(mainwindow->maincurve->baseline_color);

    mainwindow->maincurve->update();
  }
}



void UI_OptionsDialog::Crh1ColorButtonClicked(SpecialButton *)
{
  int color;

  UI_ColorMenuDialog colormenudialog(&color);

  if(color < 0)  return;

  Crh1ColorButton->setColor((Qt::GlobalColor)color);

  mainwindow->maincurve->crosshair_1_color = color;

  mainwindow->maincurve->update();
}



void UI_OptionsDialog::Crh2ColorButtonClicked(SpecialButton *)
{
  int color;

  UI_ColorMenuDialog colormenudialog(&color);

  if(color < 0)  return;

  Crh2ColorButton->setColor((Qt::GlobalColor)color);

  mainwindow->maincurve->crosshair_2_color = color;

  mainwindow->maincurve->update();
}


void UI_OptionsDialog::FrColorButtonClicked(SpecialButton *)
{
  int color;

  UI_ColorMenuDialog colormenudialog(&color);

  if(color < 0)  return;

  FrColorButton->setColor((Qt::GlobalColor)color);

  mainwindow->maincurve->floating_ruler_color = color;

  mainwindow->maincurve->update();
}


void UI_OptionsDialog::AnnotMkrButtonClicked(SpecialButton *)
{
  QColor temp;

  temp = QColorDialog::getColor(mainwindow->maincurve->annot_marker_color, tab1);

  if(temp.isValid())
  {
    mainwindow->maincurve->annot_marker_color = temp;

    AnnotMkrButton->setColor(mainwindow->maincurve->annot_marker_color);

    mainwindow->maincurve->update();
  }
}





