/* ------------------------------------------------------------------------
 * TriangleGeometryImpl.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-06-21 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _TriangleGeometryImpl_hh_
#define _TriangleGeometryImpl_hh_

// -- 3Dwm Includes
#include "Polhem/GeometryImpl.hh"
#include "Nobel/TriangleGeometry.hh"

// -- Namespace Definitions

class TriangleGeometryImpl : public virtual POA_Nobel::TriangleGeometry,
			     public FaceGeometryImpl {    
public:
    
    /**
     * Default constructor
     **/
    TriangleGeometryImpl();
    
    /**
     * Destructor
     **/
    virtual ~TriangleGeometryImpl();
    
    // IDL Operations
    virtual void render(Nobel::Renderer_ptr r);
    virtual void setVertexNumber(CORBA::Long n);
    virtual void setNormalNumber(CORBA::Long n);
    virtual void setTexCoordNumber(CORBA::Long n);
    virtual void setFaceNumber(CORBA::Long n);

    virtual void setVertex(CORBA::Long index, const Nobel::Vertex3D &v);
    virtual Nobel::Vertex3D getVertex(CORBA::Long index);
    virtual void setTexCoord(CORBA::Long index, const Nobel::TexCoord &tc);
    virtual Nobel::TexCoord getTexCoord(CORBA::Long index);
    virtual void setNormal(CORBA::Long index, const Nobel::Vertex3D &n);
    virtual Nobel::Vertex3D getNormal(CORBA::Long index);
   
    virtual void setVertexIndex(CORBA::Long index, const Nobel::Triangle &f);
    virtual Nobel::Triangle getVertexIndex(CORBA::Long index);
    virtual void setTexCoordIndex(CORBA::Long index, const Nobel::Triangle &f);
    virtual Nobel::Triangle getTexCoordIndex(CORBA::Long index);
    virtual void setNormalIndex(CORBA::Long index, const Nobel::Triangle &f);
    virtual Nobel::Triangle getNormalIndex(CORBA::Long index);
    virtual Nobel::TriangleMesh *getMesh();
    virtual void setMesh(const Nobel::TriangleMesh &mesh);
    
protected:

    /**
     * Recompute bounding volume. This will step through all the
     * vertices in the geometry and recreate the bounding volume for
     * it.
     **/
    virtual void recomputeBoundingVolume();
    
    /// Utility access functions
    static inline int offset(int n, int c = 0) { return n * 3 + c; }
    static inline int a(int n = 0) { return offset(n, 0); }
    static inline int b(int n = 0) { return offset(n, 1); }
    static inline int c(int n = 0) { return offset(n, 2); }
    
    /// Face access
    Nobel::Triangle face(const Nobel::IndexSeq &is, int n) const{
	Nobel::Triangle f;
	f.a = is[a(n)]; f.b = is[b(n)]; f.c = is[c(n)];
	return f;
    }
    
    Nobel::TriangleMesh _mesh;
};    

#endif /* TriangleGeometryImpl.hh */
