/* ------------------------------------------------------------------------
 * TransformImpl.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-08-11 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _TransformImpl_hh_
#define _TransformImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Transform.hh"
#include "Celsius/Matrix3D.hh"
#include "Celsius/Mutex.hh"

// -- Forward Declarations
class Mutex;
class Matrix3D;

// -- Class Declarations

class TransformImpl : public virtual POA_Nobel::Transform,
		      public virtual PortableServer::RefCountServantBase {
    
public:
    
    /**
     * Constructor.
     **/
    TransformImpl();

    /**
     * Copy constructor.
     *
     * @param t source transform.
     **/
    TransformImpl(const TransformImpl &t);
    
    /**
     * Destructor.
     **/
    ~TransformImpl();
    
    // IDL functions
    virtual void load(const Nobel::Matrix m);
    virtual void store(Nobel::Matrix m);
    virtual void premultiply(Nobel::Transform_ptr t);
    virtual void postmultiply(Nobel::Transform_ptr t);
    virtual void identity();
    virtual void scale(const Nobel::Vertex3D &v);
    virtual void rotate(CORBA::Float angle, const Nobel::Vertex3D &axis);
    virtual void translate(const Nobel::Vertex3D &v);
    virtual void invert();
    
    /**
     * Retrieve the internal transformation matrix object.
     *
     * @return const reference to matrix object representing
     *         transformation.
     **/
    const Matrix3D &matrix() const {
	return _matrix; 
    }

    /**
     * Assignment operator.
     *
     * @param t source transform.
     **/
    TransformImpl &operator = (const TransformImpl &t);
    
private:
    Mutex _mutex;
    Matrix3D _matrix;
};

#endif /* TransformImpl.hh */
