/* ------------------------------------------------------------------------
 * $Id: Group.hh,v 1.4 2001/07/13 12:50:18 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-04-25 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Group_hh_
#define _Group_hh_

// -- System Includes
#include <list>

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Polhem/Tagged.hh"
#include "Polhem/NodeImpl.hh"

// -- Forward Declarations
class VolumeImpl;
class TransformImpl;

// -- Class Declarations

/**
 * Group node class. Used for grouping nodes.
 **/
class Group : public NodeImpl {

public:

    /**
     * Default constructor.
     **/
    Group();

    /**
     * Destructor.
     **/
    virtual ~Group();
    
    // IDL functions
    virtual Nobel::Tag insert(Nobel::Node_ptr n);
    virtual Nobel::Transform_ptr transformation();
    virtual void remove(Nobel::Tag t);  
    virtual void traverse(Nobel::Visitor_ptr v);
    virtual void render(Nobel::Renderer_ptr r);
    virtual void pick(Nobel::Picker_ptr p);
    virtual Nobel::Volume_ptr getBoundingVolume();
    
protected:

    virtual void recomputeBoundingVolume();

    /// Node transform 
    TransformImpl *_transform;

    /// Tagged node type definition
    typedef Tagged<Nobel::Node_var, Nobel::Tag> node_t;
    
    /// Child nodes
    std::list<node_t> _childlist;

    /// Bounding volume
    VolumeImpl *_bounds;
};

#endif /* Group.hh */
