#include "forms.h"
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

struct setup Setup;
struct statxmysqladmin Stat;
void setupDefaults(void);
extern void configure_readfile(struct setup *val);

void setupDefaults()
{
  Setup.statusRefreshTime = 60;
  Setup.host[0] = '\0';
  Setup.user[0] = '\0';
  Setup.password[0] = '\0';
  strcpy(Setup.datapath, MYSQLDBDIR);
  sprintf(Setup.port, "%d", MYSQL_PORT);

  Setup.statusMaxLines = 50;
  Setup.threadsRefreshTime = 60;
  Setup.reloadRefreshTime = 3600;
  Setup.reloadMaxLines = 50;
  configure_readfile(&Setup);
  memset(&Stat, '\0', sizeof(struct statxmysqladmin));
}

int main(int argc, char *argv[])
{
  FD_main *fdui;
  fl_initialize(&argc, argv, "xMySQLadmin", 0,0);


  /* --------------------------------------------------------------------------------
   setup by default.  Will be overwite if user setup exist   
   -------------------------------------------------------------------------------- */
  memset(&Setup, '\0', sizeof(struct setup));
  setupDefaults();  

  
  /* --------------------------------------------------------------------------------
   create and show the main form
   -------------------------------------------------------------------------------- */
  fdui = create_form_main();
  fl_show_form(fdui->main, FL_PLACE_SIZE, FL_NOBORDER, "xMySQLadmin");

  /*-------------------------------------------*/
  /* essaie de se connecter, si ca marche pas, */
  /* active ecran de connection                */
  /*-------------------------------------------*/
  {
    MYSQL connection, *sock;

    if(!(sock = g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password)))
    {
      fl_trigger_object(fdui->connect);
    }
    else
      mysql_close(&connection);
  }
  
  
  fl_do_forms();
  
  return 0;
}

void main_quit(FL_OBJECT *obj, long data)
{
  fl_finish();
  exit(0);
}



