/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.InvalidTypeException;
import org.webmacro.NotFoundException;
import org.webmacro.servlet.CGI_Impersonator;
import org.webmacro.servlet.CookieJar;
import org.webmacro.util.Bag;
import org.webmacro.util.Log;

public class WebContext
extends Context {
    private static final Log _log = new Log("webcon", "WebContext Messages");
    HttpServletRequest _request = null;
    HttpServletResponse _response = null;

    public WebContext(Broker broker) {
        super(broker);
        try {
            String string = (String)broker.getValue("config", "WebContextTools");
            this.registerTools(string);
        }
        catch (InvalidTypeException invalidTypeException) {
            _log.exception(invalidTypeException);
            _log.error("config type not registered with broker!");
        }
        catch (NotFoundException notFoundException) {
            _log.exception(notFoundException);
            _log.warning("could not load WebContextTools from config: " + notFoundException);
        }
    }

    public final WebContext newInstance(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            WebContext webContext = (WebContext)this.clone();
            webContext._request = httpServletRequest;
            webContext._response = httpServletResponse;
            return webContext;
        }
        catch (Exception exception) {
            _log.error("Clone not supported on WebContext!");
            return null;
        }
    }

    public void clear() {
        super.clear();
        this._request = null;
        this._response = null;
    }

    public final HttpServletRequest getRequest() {
        return this._request;
    }

    public final HttpServletResponse getResponse() {
        return this._response;
    }

    public final String getForm(String string) {
        try {
            Bag bag = (Bag)this.getTool("Form");
            return (String)bag.get(string);
        }
        catch (Exception exception) {
            _log.exception(exception);
            _log.error("Could not load Form tool");
            return null;
        }
    }

    public final String[] getFormList(String string) {
        try {
            Bag bag = (Bag)this.getTool("FormList");
            return (String[])bag.get(string);
        }
        catch (Exception exception) {
            _log.exception(exception);
            _log.error("Could not load FormList tool");
            return null;
        }
    }

    public final CGI_Impersonator getCGI() {
        try {
            return (CGI_Impersonator)this.getTool("CGI");
        }
        catch (Exception exception) {
            _log.exception(exception);
            _log.error("Could not load CGI tool");
            return null;
        }
    }

    public final Cookie getCookie(String string) {
        try {
            CookieJar cookieJar = (CookieJar)this.getTool("Cookie");
            return (Cookie)cookieJar.get(string);
        }
        catch (Exception exception) {
            _log.exception(exception);
            _log.error("Could not load Cookie tool");
            return null;
        }
    }

    public final void setCookie(String string, String string2) {
        try {
            CookieJar cookieJar = (CookieJar)this.getTool("Cookie");
            cookieJar.set(string, string2);
        }
        catch (Exception exception) {
            _log.exception(exception);
            _log.error("Could not load Cookie tool");
        }
    }

    public final HttpSession getSession() {
        try {
            return (HttpSession)this.getTool("Session");
        }
        catch (Exception exception) {
            _log.exception(exception);
            _log.error("Could not load Session tool");
            return null;
        }
    }
}

